/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.UserCredentialStoreManager;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.Auth;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.CredentialHelper;

public class AccountCredentialResource {
    private static final Logger logger = Logger.getLogger(AccountCredentialResource.class);
    public static final String TYPE = "type";
    public static final String ENABLED_ONLY = "enabled-only";
    public static final String USER_CREDENTIALS = "user-credentials";
    private final KeycloakSession session;
    private final UserModel user;
    private final RealmModel realm;
    private Auth auth;

    public AccountCredentialResource(KeycloakSession session, UserModel user, Auth auth) {
        this.session = session;
        this.user = user;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<CredentialContainer> credentialTypes(@QueryParam(value="type") String type, @QueryParam(value="user-credentials") Boolean userCredentials) {
        this.auth.requireOneOf("manage-account", "view-profile");
        boolean includeUserCredentials = userCredentials == null || userCredentials != false;
        List<CredentialProvider> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, CredentialProvider.class).collect(Collectors.toList());
        Set<String> enabledCredentialTypes = this.getEnabledCredentialTypes(credentialProviders);
        Stream modelsStream = includeUserCredentials ? this.session.userCredentialManager().getStoredCredentialsStream(this.realm, this.user) : Stream.empty();
        List models = modelsStream.peek(model -> model.setSecretData(null)).collect(Collectors.toList());
        Function<CredentialProvider, CredentialContainer> toCredentialContainer = credentialProvider -> {
            CredentialTypeMetadataContext ctx = CredentialTypeMetadataContext.builder().user(this.user).build(this.session);
            CredentialTypeMetadata metadata = credentialProvider.getCredentialTypeMetadata(ctx);
            List<Object> userCredentialModels = null;
            if (includeUserCredentials) {
                userCredentialModels = models.stream().filter(credentialModel -> credentialProvider.getType().equals(credentialModel.getType())).map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
                if (userCredentialModels.isEmpty() && this.session.userCredentialManager().isConfiguredFor(this.realm, this.user, credentialProvider.getType())) {
                    CredentialRepresentation credential = CredentialHelper.createUserStorageCredentialRepresentation((String)credentialProvider.getType());
                    userCredentialModels = Collections.singletonList(credential);
                }
                if (userCredentialModels.isEmpty() && metadata.getCreateAction() == null && metadata.getUpdateAction() == null) {
                    return null;
                }
            }
            return new CredentialContainer(metadata, userCredentialModels);
        };
        return credentialProviders.stream().filter(p -> type == null || Objects.equals(p.getType(), type)).filter(p -> enabledCredentialTypes.contains(p.getType())).map(toCredentialContainer).filter(Objects::nonNull).sorted(Comparator.comparing(CredentialContainer::getMetadata));
    }

    private Set<String> getEnabledCredentialTypes(List<CredentialProvider> credentialProviders) {
        Stream enabledCredentialTypes = this.realm.getAuthenticationFlowsStream().filter(((Predicate<AuthenticationFlowModel>)this::isFlowEffectivelyDisabled).negate()).flatMap(flow -> this.realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> Objects.nonNull(exe.getAuthenticator()) && exe.getRequirement() != AuthenticationExecutionModel.Requirement.DISABLED).map(exe -> (AuthenticatorFactory)this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator())).filter(Objects::nonNull).map(ConfigurableAuthenticatorFactory::getReferenceCategory).filter(Objects::nonNull));
        Set credentialTypes = credentialProviders.stream().map(CredentialProvider::getType).collect(Collectors.toSet());
        return enabledCredentialTypes.filter(credentialTypes::contains).collect(Collectors.toSet());
    }

    private boolean isFlowEffectivelyDisabled(AuthenticationFlowModel flow) {
        while (!flow.isTopLevel()) {
            AuthenticationExecutionModel flowExecution = this.realm.getAuthenticationExecutionByFlowId(flow.getId());
            if (flowExecution == null) {
                return false;
            }
            if (AuthenticationExecutionModel.Requirement.DISABLED == flowExecution.getRequirement()) {
                return true;
            }
            if (flowExecution.getParentFlow() == null) {
                return false;
            }
            flow = this.realm.getAuthenticationFlowById(flowExecution.getParentFlow());
            if (flow != null) continue;
            return false;
        }
        return false;
    }

    @Path(value="{credentialId}")
    @DELETE
    @NoCache
    public void removeCredential(@PathParam(value="credentialId") String credentialId) {
        this.auth.require("manage-account");
        CredentialModel credential = this.session.userCredentialManager().getStoredCredentialById(this.realm, this.user, credentialId);
        if (credential == null) {
            throw new NotFoundException("Credential not found");
        }
        this.session.userCredentialManager().removeStoredCredential(this.realm, this.user, credentialId);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="{credentialId}/label")
    @NoCache
    public void setLabel(@PathParam(value="credentialId") String credentialId, String userLabel) {
        this.auth.require("manage-account");
        CredentialModel credential = this.session.userCredentialManager().getStoredCredentialById(this.realm, this.user, credentialId);
        if (credential == null) {
            throw new NotFoundException("Credential not found");
        }
        try {
            String label = (String)JsonSerialization.readValue((String)userLabel, String.class);
            this.session.userCredentialManager().updateCredentialLabel(this.realm, this.user, credentialId, label);
        }
        catch (IOException ioe) {
            throw new ErrorResponseException(ErrorResponse.error("invalidRequestMessage", Response.Status.BAD_REQUEST));
        }
    }

    public static class CredentialContainer {
        private String type;
        private String category;
        private String displayName;
        private String helptext;
        private String iconCssClass;
        private String createAction;
        private String updateAction;
        private boolean removeable;
        private List<CredentialRepresentation> userCredentials;
        private CredentialTypeMetadata metadata;

        public CredentialContainer() {
        }

        public CredentialContainer(CredentialTypeMetadata metadata, List<CredentialRepresentation> userCredentials) {
            this.metadata = metadata;
            this.type = metadata.getType();
            this.category = metadata.getCategory().toString();
            this.displayName = metadata.getDisplayName();
            this.helptext = metadata.getHelpText();
            this.iconCssClass = metadata.getIconCssClass();
            this.createAction = metadata.getCreateAction();
            this.updateAction = metadata.getUpdateAction();
            this.removeable = metadata.isRemoveable();
            this.userCredentials = userCredentials;
        }

        public String getCategory() {
            return this.category;
        }

        public String getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getHelptext() {
            return this.helptext;
        }

        public String getIconCssClass() {
            return this.iconCssClass;
        }

        public String getCreateAction() {
            return this.createAction;
        }

        public String getUpdateAction() {
            return this.updateAction;
        }

        public boolean isRemoveable() {
            return this.removeable;
        }

        public List<CredentialRepresentation> getUserCredentials() {
            return this.userCredentials;
        }

        @JsonIgnore
        public CredentialTypeMetadata getMetadata() {
            return this.metadata;
        }
    }
}

