/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import java.util.Map;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class UserModelIdentity
implements Identity {
    protected RealmModel realm;
    protected UserModel user;

    public UserModelIdentity(RealmModel realm, UserModel user) {
        this.realm = realm;
        this.user = user;
    }

    public String getId() {
        return this.user.getId();
    }

    public Attributes getAttributes() {
        Map attr = this.user.getAttributes();
        return Attributes.from((Map)attr);
    }

    public boolean hasRealmRole(String roleName) {
        RoleModel role = this.realm.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.user.hasRole(role);
    }

    public boolean hasClientRole(String clientId, String roleName) {
        ClientModel client = this.realm.getClientByClientId(clientId);
        RoleModel role = client.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.user.hasRole(role);
    }
}

