/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.clientpolicy.ClientPoliciesUtil;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.services.clientpolicy.ClientPolicyModel;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.ClientProfileModel;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class DefaultClientPolicyManager
implements ClientPolicyManager {
    private static final Logger logger = Logger.getLogger(DefaultClientPolicyManager.class);
    private final KeycloakSession session;
    public static final String CLIENT_PROFILES = "client-policies.profiles";
    public static final String CLIENT_POLICIES = "client-policies.policies";
    private static String builtinClientProfilesJson;
    private static String builtinClientPoliciesJson;

    public DefaultClientPolicyManager(KeycloakSession session) {
        this.session = session;
    }

    public void triggerOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_POLICIES)) {
            return;
        }
        RealmModel realm = this.session.getContext().getRealm();
        logger.tracev("POLICY OPERATION :: context realm = {0}, event = {1}", (Object)realm.getName(), (Object)context.getEvent());
        this.doPolicyOperation(condition -> condition.applyPolicy(context), executor -> executor.executeOnEvent(context), realm);
    }

    private void doPolicyOperation(ClientConditionOperation condition, ClientExecutorOperation executor, RealmModel realm) throws ClientPolicyException {
        Map map = ClientPoliciesUtil.getClientProfilesModel((KeycloakSession)this.session, (RealmModel)realm);
        List list = ClientPoliciesUtil.getEnabledClientProfilesModel((KeycloakSession)this.session, (RealmModel)realm).stream().collect(Collectors.toList());
        if (list == null || list.isEmpty()) {
            logger.trace((Object)"POLICY OPERATION :: No enabled policy.");
            return;
        }
        for (ClientPolicyModel policy : list) {
            logger.tracev("POLICY OPERATION :: policy name = {0}, isBuiltin = {1}", (Object)policy.getName(), (Object)policy.isBuiltin());
            if (!this.isSatisfied(policy, condition)) {
                logger.tracev("POLICY UNSATISFIED :: policy name = {0}, isBuiltin = {1}", (Object)policy.getName(), (Object)policy.isBuiltin());
                continue;
            }
            logger.tracev("POLICY APPLIED :: policy name = {0}, isBuiltin = {1}", (Object)policy.getName(), (Object)policy.isBuiltin());
            this.execute(policy, executor, map);
        }
    }

    private boolean isSatisfied(ClientPolicyModel policy, ClientConditionOperation op) throws ClientPolicyException {
        if (policy.getConditions() == null || policy.getConditions().isEmpty()) {
            logger.tracev("NO CONDITION :: policy name = {0}", (Object)policy.getName());
            return false;
        }
        boolean ret = false;
        for (Object obj : policy.getConditions()) {
            ClientPolicyConditionProvider condition = (ClientPolicyConditionProvider)obj;
            logger.tracev("CONDITION OPERATION :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
            try {
                ClientPolicyVote vote = op.run(condition);
                if (condition.isNegativeLogic()) {
                    if (vote == ClientPolicyVote.YES) {
                        vote = ClientPolicyVote.NO;
                    } else if (vote == ClientPolicyVote.NO) {
                        vote = ClientPolicyVote.YES;
                    }
                }
                if (vote == ClientPolicyVote.ABSTAIN) {
                    logger.tracev("CONDITION SKIP :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
                    continue;
                }
                if (vote == ClientPolicyVote.NO) {
                    logger.tracev("CONDITION NEGATIVE :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
                    return false;
                }
                ret = true;
            }
            catch (ClientPolicyException e) {
                logger.tracev("CONDITION EXCEPTION :: policy name = {0}, provider id = {1}, error = {2}, error detail = {3}", new Object[]{condition.getName(), condition.getProviderId(), e.getError(), e.getErrorDetail()});
                throw e;
            }
        }
        if (ret) {
            logger.tracev("CONDITIONS SATISFIED :: policy name = {0}", (Object)policy.getName());
        } else {
            logger.tracev("CONDITIONS UNSATISFIED :: policy name = {0}", (Object)policy.getName());
        }
        return ret;
    }

    private void execute(ClientPolicyModel policy, ClientExecutorOperation op, Map<String, ClientProfileModel> map) throws ClientPolicyException {
        if (policy.getProfiles() == null || policy.getProfiles().isEmpty()) {
            logger.tracev("NO PROFILE :: policy name = {0}", (Object)policy.getName());
        }
        for (String profileName : policy.getProfiles()) {
            ClientProfileModel profile = map.get(profileName);
            if (profile == null) {
                logger.tracev("PROFILE NOT FOUND :: policy name = {0}, profile name = {1}", (Object)policy.getName(), (Object)profileName);
                continue;
            }
            if (profile.getExecutors() == null || profile.getExecutors().isEmpty()) {
                logger.tracev("PROFILE NO EXECUTOR :: policy name = {0}, profile name = {1}", (Object)policy.getName(), (Object)profileName);
                continue;
            }
            for (Object obj : profile.getExecutors()) {
                ClientPolicyExecutorProvider executor = (ClientPolicyExecutorProvider)obj;
                logger.tracev("EXECUTION :: policy name = {0}, profile name = {1}, executor name = {2}, provider id = {3}", new Object[]{policy.getName(), profileName, executor.getName(), executor.getProviderId()});
                try {
                    op.run(executor);
                }
                catch (ClientPolicyException e) {
                    logger.tracev("EXECUTOR EXCEPTION :: executor name = {0}, provider id = {1}, error = {2}, error detail = {3}", new Object[]{executor.getName(), executor.getProviderId(), e.getError(), e.getErrorDetail()});
                    throw e;
                }
            }
        }
    }

    public void setupClientPoliciesOnKeycloakApp(String profilesFilePath, String policiesFilePath) {
        logger.trace((Object)"LOAD BUILTIN PROFILE POLICIES ON KEYCLOAK");
        ClientProfilesRepresentation validatedProfilesRep = null;
        try {
            validatedProfilesRep = ClientPoliciesUtil.getValidatedBuiltinClientProfilesRepresentation((KeycloakSession)this.session, (InputStream)this.getClass().getResourceAsStream(profilesFilePath));
        }
        catch (ClientPolicyException cpe) {
            logger.warnv("LOAD BUILTIN PROFILES ON KEYCLOAK FAILED :: error = {0}, error detail = {1}", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
            return;
        }
        String validatedJson = null;
        try {
            validatedJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)validatedProfilesRep);
        }
        catch (ClientPolicyException cpe) {
            logger.warnv("VALIDATE SERIALIZE BUILTIN PROFILES ON KEYCLOAK FAILED :: error = {0}, error detail = {1}", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
            return;
        }
        builtinClientProfilesJson = validatedJson;
        ClientPoliciesRepresentation validatedPoliciesRep = null;
        try {
            validatedPoliciesRep = ClientPoliciesUtil.getValidatedBuiltinClientPoliciesRepresentation((KeycloakSession)this.session, (InputStream)this.getClass().getResourceAsStream(policiesFilePath));
        }
        catch (ClientPolicyException cpe) {
            logger.warnv("LOAD BUILTIN POLICIES ON KEYCLOAK FAILED :: error = {0}, error detail = {1}", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
            builtinClientProfilesJson = null;
            return;
        }
        validatedJson = null;
        try {
            validatedJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)validatedPoliciesRep);
        }
        catch (ClientPolicyException cpe) {
            logger.warnv("VALIDATE SERIALIZE BUILTIN POLICIES ON KEYCLOAK FAILED :: error = {0}, error detail = {1}", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
            builtinClientProfilesJson = null;
            return;
        }
        builtinClientPoliciesJson = validatedJson;
    }

    public void setupClientPoliciesOnCreatedRealm(RealmModel realm) {
        logger.tracev("LOAD BUILTIN PROFILE POLICIES ON CREATED REALM :: realm = {0}", (Object)realm.getName());
        this.setClientProfilesJsonString(realm, builtinClientProfilesJson);
        this.setClientPoliciesJsonString(realm, builtinClientPoliciesJson);
    }

    public void setupClientPoliciesOnImportedRealm(RealmModel realm, RealmRepresentation rep) {
        logger.tracev("LOAD PROFILE POLICIES ON IMPORTED REALM :: realm = {0}", (Object)realm.getName());
        this.setClientProfilesJsonString(realm, builtinClientProfilesJson);
        this.setClientPoliciesJsonString(realm, builtinClientPoliciesJson);
        String validatedJson = null;
        try {
            validatedJson = ClientPoliciesUtil.getValidatedClientProfilesJson((KeycloakSession)this.session, (RealmModel)realm, (ClientProfilesRepresentation)rep.getClientProfiles());
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE IMPORTED REALM PROFILES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            validatedJson = builtinClientProfilesJson;
        }
        this.setClientProfilesJsonString(realm, validatedJson);
        try {
            validatedJson = ClientPoliciesUtil.getValidatedClientPoliciesJson((KeycloakSession)this.session, (RealmModel)realm, (ClientPoliciesRepresentation)rep.getClientPolicies());
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE IMPORTED REALM POLICIES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            validatedJson = builtinClientPoliciesJson;
        }
        this.setClientPoliciesJsonString(realm, validatedJson);
    }

    public void updateClientProfiles(RealmModel realm, String json) throws ClientPolicyException {
        logger.tracev("UPDATE PROFILES :: realm = {0}, PUT = {1}", (Object)realm.getName(), (Object)json);
        String validatedJsonString = null;
        try {
            validatedJsonString = this.getValidatedClientProfilesJson(realm, json);
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE PROFILES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
        this.setClientProfilesJsonString(realm, validatedJsonString);
        logger.tracev("UPDATE PROFILES :: realm = {0}, validated and modified PUT = {1}", (Object)realm.getName(), (Object)validatedJsonString);
    }

    public String getClientProfiles(RealmModel realm) {
        String json = this.getClientProfilesJsonString(realm);
        logger.tracev("GET PROFILES :: realm = {0}, GET = {1}", (Object)realm.getName(), (Object)json);
        return json;
    }

    public void updateClientPolicies(RealmModel realm, String json) throws ClientPolicyException {
        logger.tracev("UPDATE POLICIES :: realm = {0}, PUT = {1}", (Object)realm.getName(), (Object)json);
        String validatedJsonString = null;
        try {
            validatedJsonString = this.getValidatedClientPoliciesJson(realm, json);
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE POLICIES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
        this.setClientPoliciesJsonString(realm, validatedJsonString);
        logger.tracev("UPDATE POLICIES :: realm = {0}, validated and modified PUT = {1}", (Object)realm.getName(), (Object)validatedJsonString);
    }

    public void setupClientPoliciesOnExportingRealm(RealmModel realm, RealmRepresentation rep) {
        ClientProfilesRepresentation filteredOutProfiles = null;
        try {
            filteredOutProfiles = this.getClientProfilesForExport(realm);
        }
        catch (ClientPolicyException clientPolicyException) {
            // empty catch block
        }
        rep.setClientProfiles(filteredOutProfiles);
        ClientPoliciesRepresentation filteredOutPolicies = null;
        try {
            filteredOutPolicies = this.getClientPoliciesForExport(realm);
        }
        catch (ClientPolicyException clientPolicyException) {
            // empty catch block
        }
        rep.setClientPolicies(filteredOutPolicies);
    }

    public String getClientPolicies(RealmModel realm) {
        String json = this.getClientPoliciesJsonString(realm);
        logger.tracev("GET POLICIES :: realm = {0}, GET = {1}", (Object)realm.getName(), (Object)json);
        return json;
    }

    public String getClientProfilesOnKeycloakApp() {
        return builtinClientProfilesJson;
    }

    public String getClientPoliciesOnKeycloakApp() {
        return builtinClientPoliciesJson;
    }

    public String getClientProfilesJsonString(RealmModel realm) {
        return realm.getAttribute(CLIENT_PROFILES);
    }

    public String getClientPoliciesJsonString(RealmModel realm) {
        return realm.getAttribute(CLIENT_POLICIES);
    }

    private void setClientProfilesJsonString(RealmModel realm, String json) {
        realm.setAttribute(CLIENT_PROFILES, json);
    }

    private void setClientPoliciesJsonString(RealmModel realm, String json) {
        realm.setAttribute(CLIENT_POLICIES, json);
    }

    private String getValidatedClientProfilesJson(RealmModel realm, String profilesJson) throws ClientPolicyException {
        ClientProfilesRepresentation validatedProfilesRep = ClientPoliciesUtil.getValidatedClientProfilesRepresentation((KeycloakSession)this.session, (RealmModel)realm, (String)profilesJson);
        return ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)validatedProfilesRep);
    }

    private String getValidatedClientPoliciesJson(RealmModel realm, String policiesJson) throws ClientPolicyException {
        ClientPoliciesRepresentation validatedPoliciesRep = ClientPoliciesUtil.getValidatedClientPoliciesRepresentation((KeycloakSession)this.session, (RealmModel)realm, (String)policiesJson);
        return ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)validatedPoliciesRep);
    }

    private ClientProfilesRepresentation getClientProfilesForExport(RealmModel realm) throws ClientPolicyException {
        ClientProfilesRepresentation profilesRep = ClientPoliciesUtil.getClientProfilesRepresentation((KeycloakSession)this.session, (RealmModel)realm);
        if (profilesRep == null || profilesRep.getProfiles() == null) {
            return new ClientProfilesRepresentation();
        }
        List filteredProfileRepList = profilesRep.getProfiles().stream().filter(profileRep -> profileRep.isBuiltin() == false).collect(Collectors.toList());
        profilesRep.setProfiles(filteredProfileRepList);
        return profilesRep;
    }

    private ClientPoliciesRepresentation getClientPoliciesForExport(RealmModel realm) throws ClientPolicyException {
        ClientPoliciesRepresentation policiesRep = ClientPoliciesUtil.getClientPoliciesRepresentation((KeycloakSession)this.session, (RealmModel)realm);
        if (policiesRep == null || policiesRep.getPolicies() == null) {
            return new ClientPoliciesRepresentation();
        }
        policiesRep.getPolicies().stream().forEach(policyRep -> {
            if (policyRep.isBuiltin().booleanValue()) {
                policyRep.setDescription(null);
                policyRep.setConditions(null);
                policyRep.setProfiles(null);
            }
        });
        return policiesRep;
    }

    private static interface ClientExecutorOperation {
        public void run(ClientPolicyExecutorProvider var1) throws ClientPolicyException;
    }

    private static interface ClientConditionOperation {
        public ClientPolicyVote run(ClientPolicyConditionProvider var1) throws ClientPolicyException;
    }
}

