/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientRolesCondition
implements ClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientRolesCondition.class);
    private Configuration configuration = new Configuration();
    private final KeycloakSession session;

    public ClientRolesCondition(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public boolean isNegativeLogic() {
        return Optional.ofNullable(this.configuration.isNegativeLogic()).orElse(Boolean.FALSE);
    }

    public String getProviderId() {
        return "clientroles-condition";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: {
                if (this.isRolesMatched(this.session.getContext().getClient())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isRolesMatched(ClientModel client) {
        if (client == null) {
            return false;
        }
        Set<String> rolesForMatching = this.getRolesForMatching();
        if (rolesForMatching == null) {
            return false;
        }
        Set<String> clientRoles = client.getRolesStream().map(RoleModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            clientRoles.forEach(i -> logger.tracev("client role assigned = {0}", i));
            rolesForMatching.forEach(i -> logger.tracev("client role for matching = {0}", i));
        }
        return rolesForMatching.removeAll(clientRoles);
    }

    private Set<String> getRolesForMatching() {
        if (this.configuration.getRoles() == null) {
            return null;
        }
        return new HashSet<String>(this.configuration.getRoles());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyConditionConfiguration {
        @JsonProperty(value="is-negative-logic")
        protected Boolean negativeLogic;
        protected List<String> roles;

        public Boolean isNegativeLogic() {
            return this.negativeLogic;
        }

        public void setNegativeLogic(Boolean negativeLogic) {
            this.negativeLogic = negativeLogic;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

