/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.ClientModelIdentity;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.IdentityProviderPermissionManagement;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;

class IdentityProviderPermissions
implements IdentityProviderPermissionManagement {
    private static final Logger logger = Logger.getLogger(IdentityProviderPermissions.class);
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;

    public IdentityProviderPermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
    }

    private String getResourceName(IdentityProviderModel idp) {
        return "idp.resource." + idp.getInternalId();
    }

    private String getExchangeToPermissionName(IdentityProviderModel idp) {
        return "token-exchange.permission.idp." + idp.getInternalId();
    }

    private void initialize(IdentityProviderModel idp) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        Scope exchangeToScope = this.root.initializeScope("token-exchange", server);
        String resourceName = this.getResourceName(idp);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(resourceName, server.getId());
        if (resource == null) {
            resource = this.authz.getStoreFactory().getResourceStore().create(resourceName, server, server.getId());
            resource.setType("IdentityProvider");
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(exchangeToScope);
            resource.updateScopes(scopeset);
        }
        String exchangeToPermissionName = this.getExchangeToPermissionName(idp);
        Policy exchangeToPermission = this.authz.getStoreFactory().getPolicyStore().findByName(exchangeToPermissionName, server.getId());
        if (exchangeToPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, exchangeToPermissionName, resource, exchangeToScope);
        }
    }

    private void deletePolicy(String name, ResourceServer server) {
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(name, server.getId());
        if (policy != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(policy.getId());
        }
    }

    private void deletePermissions(IdentityProviderModel idp) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            return;
        }
        this.deletePolicy(this.getExchangeToPermissionName(idp), server);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(idp), server.getId());
        if (resource != null) {
            this.authz.getStoreFactory().getResourceStore().delete(resource.getId());
        }
    }

    @Override
    public boolean isPermissionsEnabled(IdentityProviderModel idp) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            return false;
        }
        return this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(idp), server.getId()) != null;
    }

    @Override
    public void setPermissionsEnabled(IdentityProviderModel idp, boolean enable) {
        if (enable) {
            this.initialize(idp);
        } else {
            this.deletePermissions(idp);
        }
    }

    private Scope exchangeToScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName("token-exchange", server.getId());
    }

    @Override
    public Resource resource(IdentityProviderModel idp) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            return null;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(idp), server.getId());
        if (resource == null) {
            return null;
        }
        return resource;
    }

    @Override
    public Map<String, String> getPermissions(IdentityProviderModel idp) {
        this.initialize(idp);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("token-exchange", this.exchangeToPermission(idp).getId());
        return scopes;
    }

    @Override
    public boolean canExchangeTo(final ClientModel authorizedClient, IdentityProviderModel to) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            logger.debug((Object)"No resource server set up for target idp");
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(this.getResourceName(to), server.getId());
        if (resource == null) {
            logger.debug((Object)"No resource object set up for target idp");
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(this.getExchangeToPermissionName(to), server.getId());
        if (policy == null) {
            logger.debug((Object)"No permission object set up for target idp");
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            logger.debug((Object)"No policies set up for permission on target idp");
            return false;
        }
        Scope scope = this.exchangeToScope(server);
        if (scope == null) {
            logger.debug((Object)"token-exchange not initialized");
            return false;
        }
        ClientModelIdentity identity = new ClientModelIdentity(this.session, authorizedClient);
        DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session){

            @Override
            public Map<String, Collection<String>> getBaseAttributes() {
                Map<String, Collection<String>> attributes = super.getBaseAttributes();
                attributes.put("kc.client.id", Arrays.asList(authorizedClient.getClientId()));
                return attributes;
            }
        };
        return this.root.evaluatePermission(resource, server, context, scope);
    }

    @Override
    public Policy exchangeToPermission(IdentityProviderModel idp) {
        ResourceServer server = this.root.initializeRealmResourceServer();
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(this.getExchangeToPermissionName(idp), server.getId());
    }
}

