/*
 * Copyright 2002-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak;

public interface WebAuthnConstants {

    // Interface binded by FreeMarker template between UA and RP
    final String USER_ID = "userid";
    final String USER_NAME = "username";
    final String CHALLENGE = "challenge";
    final String ORIGIN = "origin";
    final String ERROR = "error";
    final String PUBLIC_KEY_CREDENTIAL_ID= "publicKeyCredentialId";
    final String CREDENTIAL_ID = "credentialId";
    final String CLIENT_DATA_JSON = "clientDataJSON";
    final String AUTHENTICATOR_DATA = "authenticatorData";
    final String SIGNATURE = "signature";
    final String USER_HANDLE = "userHandle";
    final String ATTESTATION_OBJECT= "attestationObject";
    final String AUTHENTICATOR_LABEL = "authenticatorLabel";
    final String RP_ENTITY_NAME = "rpEntityName";
    final String SIGNATURE_ALGORITHMS = "signatureAlgorithms";
    final String RP_ID = "rpId";
    final String ATTESTATION_CONVEYANCE_PREFERENCE = "attestationConveyancePreference";
    final String AUTHENTICATOR_ATTACHMENT = "authenticatorAttachment";
    final String REQUIRE_RESIDENT_KEY = "requireResidentKey";
    final String USER_VERIFICATION_REQUIREMENT = "userVerificationRequirement";
    final String CREATE_TIMEOUT = "createTimeout";
    final String EXCLUDE_CREDENTIAL_IDS = "excludeCredentialIds";
    final String ALLOWED_AUTHENTICATORS = "authenticators";
    final String IS_USER_IDENTIFIED = "isUserIdentified";
    final String USER_VERIFICATION = "userVerification";
    final String IS_SET_RETRY = "isSetRetry";


    // Event key for credential id generated by navigator.credentials.create()
    final String PUBKEY_CRED_ID_ATTR = "public_key_credential_id";

    // Event key for Public Key Credential's user-editable metadata
    final String PUBKEY_CRED_LABEL_ATTR = "public_key_credential_label";

    // Event key for Public Key Credential's AAGUID
    final String PUBKEY_CRED_AAGUID_ATTR = "public_key_credential_aaguid";

    // key for storing onto AuthenticationSessionModel's Attribute challenge generated by RP(keycloak)
    final String AUTH_CHALLENGE_NOTE = "WEBAUTH_CHALLENGE";

    // option values on WebAuth API
    final String OPTION_REQUIRED = "required";
    final String OPTION_PREFERED = "preferred";
    final String OPTION_DISCOURAGED = "discouraged";
    final String OPTION_NOT_SPECIFIED = "";
    

}
