/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.representations.idm.ErrorRepresentation;

public class ErrorResponse {
    public static Response exists(String message) {
        return ErrorResponse.error(message, Response.Status.CONFLICT);
    }

    public static Response error(String message, Response.Status status) {
        return ErrorResponse.error(message, null, status);
    }

    public static Response error(String message, Object[] params, Response.Status status) {
        ErrorRepresentation error = new ErrorRepresentation();
        error.setErrorMessage(message);
        error.setParams(params);
        return Response.status((Response.Status)status).entity((Object)error).type("application/json").build();
    }

    public static Response errors(List<ErrorRepresentation> s, Response.Status status) {
        if (s.size() == 1) {
            return Response.status((Response.Status)status).entity((Object)s.get(0)).type("application/json").build();
        }
        ErrorRepresentation error = new ErrorRepresentation();
        error.setErrors(s);
        return Response.status((Response.Status)status).entity((Object)error).type("application/json").build();
    }
}

