/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.LogoutRequestContext;
import org.keycloak.services.clientpolicy.context.TokenRefreshContext;
import org.keycloak.services.clientpolicy.context.TokenRevokeContext;
import org.keycloak.services.clientpolicy.context.UserInfoRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.util.MtlsHoKTokenUtil;

public class HolderOfKeyEnforcerExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public HolderOfKeyEnforcerExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "holder-of-key-enforcer";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        HttpRequest request = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case TOKEN_REQUEST: {
                AccessToken.CertConf certConf = MtlsHoKTokenUtil.bindTokenWithClientCertificate(request, this.session);
                if (certConf != null) break;
                throw new ClientPolicyException("invalid_request", "Client Certification missing for MTLS HoK Token Binding");
            }
            case TOKEN_REFRESH: {
                this.checkTokenRefresh((TokenRefreshContext)context, request);
                break;
            }
            case TOKEN_REVOKE: {
                this.checkTokenRevoke((TokenRevokeContext)context, request);
                break;
            }
            case USERINFO_REQUEST: {
                this.checkUserInfo((UserInfoRequestContext)context, request);
                break;
            }
            case LOGOUT_REQUEST: {
                this.checkLogout((LogoutRequestContext)context, request);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            OIDCAdvancedConfigWrapper.fromClientRepresentation(rep).setUseMtlsHoKToken(true);
        }
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        boolean useMtlsHokToken = OIDCAdvancedConfigWrapper.fromClientRepresentation(rep).isUseMtlsHokToken();
        if (!useMtlsHokToken) {
            throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: MTLS token in disabled");
        }
    }

    private void checkLogout(LogoutRequestContext context, HttpRequest request) throws ClientPolicyException {
        MultivaluedMap<String, String> formParameters = context.getParams();
        String encodedRefreshToken = (String)formParameters.getFirst((Object)"refresh_token");
        RefreshToken refreshToken = (RefreshToken)this.session.tokens().decode(encodedRefreshToken, RefreshToken.class);
        if (refreshToken == null) {
            return;
        }
        if (!MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate((AccessToken)refreshToken, request, this.session)) {
            throw new ClientPolicyException("not_allowed", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkUserInfo(UserInfoRequestContext context, HttpRequest request) throws ClientPolicyException {
        String encodedAccessToken = context.getTokenString();
        AccessToken accessToken = (AccessToken)this.session.tokens().decode(encodedAccessToken, AccessToken.class);
        if (accessToken == null) {
            return;
        }
        if (!MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate(accessToken, request, this.session)) {
            throw new ClientPolicyException("not_allowed", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkTokenRevoke(TokenRevokeContext context, HttpRequest request) throws ClientPolicyException {
        MultivaluedMap<String, String> revokeParameters = context.getParams();
        String encodedRevokeToken = (String)revokeParameters.getFirst((Object)"token");
        RefreshToken refreshToken = (RefreshToken)this.session.tokens().decode(encodedRevokeToken, RefreshToken.class);
        if (refreshToken == null) {
            return;
        }
        if (!MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate((AccessToken)refreshToken, request, this.session)) {
            throw new ClientPolicyException("not_allowed", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkTokenRefresh(TokenRefreshContext context, HttpRequest request) throws ClientPolicyException {
        MultivaluedMap<String, String> formParameters = context.getParams();
        String encodedRefreshToken = (String)formParameters.getFirst((Object)"refresh_token");
        RefreshToken refreshToken = (RefreshToken)this.session.tokens().decode(encodedRefreshToken, RefreshToken.class);
        if (refreshToken == null) {
            return;
        }
        if (!MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate((AccessToken)refreshToken, request, this.session)) {
            throw new ClientPolicyException("invalid_grant", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match", Response.Status.BAD_REQUEST);
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }
    }
}

