/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRequestObjectExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureRequestObjectExecutor.class);
    public static final String INVALID_REQUEST_OBJECT = "invalid_request_object";
    public static final Integer DEFAULT_AVAILABLE_PERIOD = 3600;
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureRequestObjectExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        if (config == null) {
            this.configuration = new Configuration();
            this.configuration.setVerifyNbf(Boolean.TRUE);
            this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
        } else {
            this.configuration = config;
            if (config.isVerifyNbf() == null) {
                this.configuration.setVerifyNbf(Boolean.TRUE);
            }
            if (config.getAvailablePeriod() == null) {
                this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
            }
        }
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-request-object";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri(), authorizationRequestContext.getRequestParameters());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri, MultivaluedMap<String, String> params) throws ClientPolicyException {
        logger.trace((Object)"Authz Endpoint - authz request");
        if (params == null) {
            logger.trace((Object)"request parameter not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameters");
        }
        String requestParam = (String)params.getFirst((Object)"request");
        String requestUriParam = (String)params.getFirst((Object)"request_uri");
        if (requestParam == null && requestUriParam == null) {
            logger.trace((Object)"request object not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameter: 'request' or 'request_uri'");
        }
        JsonNode requestObject = (JsonNode)this.session.getAttribute("ParsedRequestObject");
        if (requestObject == null || requestObject.isEmpty()) {
            logger.trace((Object)"request object not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter: : 'request' or 'request_uri'");
        }
        if (params.getFirst((Object)"scope") == null || requestObject.get("scope") == null) {
            logger.trace((Object)"scope object not exist.");
            throw new ClientPolicyException("invalid_request", "Parameter 'scope' missing in the request parameters or in 'request' object");
        }
        if (requestObject.get("exp") == null) {
            logger.trace((Object)"exp claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter in the 'request' object: exp");
        }
        long exp = requestObject.get("exp").asLong();
        if ((long)Time.currentTime() > exp) {
            logger.trace((Object)"request object expired.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request Expired");
        }
        if (Optional.ofNullable(this.configuration.isVerifyNbf()).orElse(Boolean.FALSE).booleanValue()) {
            if (requestObject.get("nbf") == null) {
                logger.trace((Object)"nbf claim not incuded.");
                throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter in the 'request' object: nbf");
            }
            long nbf = requestObject.get("nbf").asLong();
            if ((long)Time.currentTime() < nbf) {
                logger.trace((Object)"request object not yet being processed.");
                throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request not yet being processed");
            }
            int availablePeriod = Optional.ofNullable(this.configuration.getAvailablePeriod()).orElse(DEFAULT_AVAILABLE_PERIOD);
            if (exp - nbf > (long)availablePeriod) {
                logger.trace((Object)"request object's available period is long.");
                throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request's available period is long");
            }
        }
        ArrayList<String> aud = new ArrayList<String>();
        JsonNode audience = requestObject.get("aud");
        if (audience == null) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter in the 'request' object: aud");
        }
        if (audience.isArray()) {
            for (JsonNode node : audience) {
                aud.add(node.asText());
            }
        } else {
            aud.add(audience.asText());
        }
        if (aud.isEmpty()) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter value in the 'request' object: aud");
        }
        String iss = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName());
        if (!aud.contains(iss)) {
            logger.trace((Object)"aud not points to the intended realm.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Invalid parameter in the 'request' object: aud");
        }
        Optional<String> incorrectParam = AuthzEndpointRequestParser.KNOWN_REQ_PARAMS.stream().filter(param -> params.containsKey(param)).filter(param -> !this.isSameParameterIncluded((String)param, (String)params.getFirst(param), requestObject)).findFirst();
        if (incorrectParam.isPresent()) {
            logger.warnf("Parameter '%s' does not have same value in 'request' object and in request parameters", (Object)incorrectParam.get());
            throw new ClientPolicyException("invalid_request", "Invalid parameter. Parameters in 'request' object not matching with request parameters");
        }
        logger.trace((Object)"Passed.");
    }

    private boolean isSameParameterIncluded(String param, String value, JsonNode requestObject) {
        if (param.equals("request") || param.equals("request_uri")) {
            return true;
        }
        if (requestObject.hasNonNull(param)) {
            return requestObject.get(param).asText().equals(value);
        }
        return false;
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="available-period")
        protected Integer availablePeriod;
        @JsonProperty(value="verify-nbf")
        protected Boolean verifyNbf;

        public Integer getAvailablePeriod() {
            return this.availablePeriod;
        }

        public void setAvailablePeriod(Integer availablePeriod) {
            this.availablePeriod = availablePeriod;
        }

        public Boolean isVerifyNbf() {
            return this.verifyNbf;
        }

        public void setVerifyNbf(Boolean verifyNbf) {
            this.verifyNbf = verifyNbf;
        }
    }
}

