/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceHostsCondition;

public class ClientUpdaterSourceHostsConditionFactory
implements ClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-updater-source-host";
    public static final String TRUSTED_HOSTS = "trusted-hosts";
    private static final ProviderConfigProperty TRUSTED_HOSTS_PROPERTY = new ProviderConfigProperty("trusted-hosts", "client-updater-trusted-hosts.label", "client-updater-trusted-hosts.tooltip", "MultivaluedString", null);

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientUpdaterSourceHostsCondition(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks the host/domain of the entity who tries to create/update the client to determine whether the policy is applied.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Arrays.asList(TRUSTED_HOSTS_PROPERTY);
    }
}

