/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientRoleMappingsResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.ReadOnlyException;

public class RoleMapperResource {
    protected static final Logger logger = Logger.getLogger(RoleMapperResource.class);
    protected RealmModel realm;
    private RoleMapperModel roleMapper;
    private AdminEventBuilder adminEvent;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    private AdminPermissionEvaluator auth;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public RoleMapperResource(RealmModel realm, AdminPermissionEvaluator auth, RoleMapperModel roleMapper, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.REALM_ROLE_MAPPING);
        this.roleMapper = roleMapper;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings() {
        this.viewPermission.require();
        ArrayList realmRolesRepresentation = new ArrayList();
        HashMap appMappings = new HashMap();
        AtomicReference mappings = new AtomicReference();
        this.roleMapper.getRoleMappingsStream().forEach(roleMapping -> {
            RoleContainerModel container = roleMapping.getContainer();
            if (container instanceof RealmModel) {
                realmRolesRepresentation.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleMapping));
            } else if (container instanceof ClientModel) {
                ClientModel clientModel = (ClientModel)container;
                mappings.set(appMappings.get(clientModel.getClientId()));
                if (mappings.get() == null) {
                    mappings.set(new ClientMappingsRepresentation());
                    ((ClientMappingsRepresentation)mappings.get()).setId(clientModel.getId());
                    ((ClientMappingsRepresentation)mappings.get()).setClient(clientModel.getClientId());
                    ((ClientMappingsRepresentation)mappings.get()).setMappings(new ArrayList());
                    appMappings.put(clientModel.getClientId(), mappings.get());
                }
                ((ClientMappingsRepresentation)mappings.get()).getMappings().add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleMapping));
            }
        });
        MappingsRepresentation all = new MappingsRepresentation();
        if (!realmRolesRepresentation.isEmpty()) {
            all.setRealmMappings(realmRolesRepresentation);
        }
        if (!appMappings.isEmpty()) {
            all.setClientMappings(appMappings);
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getRealmRoleMappings() {
        this.viewPermission.require();
        return this.roleMapper.getRealmRoleMappingsStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getCompositeRealmRoleMappings(@QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.realm.getRolesStream().filter(arg_0 -> ((RoleMapperModel)this.roleMapper).hasRole(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getAvailableRealmRoleMappings() {
        this.viewPermission.require();
        return this.realm.getRolesStream().filter(this::canMapRole).filter(((Predicate<RoleModel>)arg_0 -> ((RoleMapperModel)this.roleMapper).hasRole(arg_0)).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        try {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                this.roleMapper.grantRole(roleModel);
            }
        }
        catch (ModelException | ReadOnlyException me) {
            logger.warn((Object)me.getMessage(), me);
            throw new ErrorResponseException("invalid_request", "Could not add user role mappings!", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debug((Object)"deleteRealmRoleMappings");
        if (roles == null) {
            roles = this.roleMapper.getRealmRoleMappingsStream().peek(roleModel -> {
                this.auth.roles().requireMapRole((RoleModel)roleModel);
                this.roleMapper.deleteRoleMapping(roleModel);
            }).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel2 = this.realm.getRole(role.getName());
                if (roleModel2 == null || !roleModel2.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel2);
                try {
                    this.roleMapper.deleteRoleMapping(roleModel2);
                }
                catch (ModelException | ReadOnlyException me) {
                    logger.warn((Object)me.getMessage(), me);
                    throw new ErrorResponseException("invalid_request", "Could not remove user role mappings!", Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    private boolean canMapRole(RoleModel roleModel) {
        return this.auth.roles().canMapRole(roleModel);
    }

    @Path(value="clients/{client}")
    public ClientRoleMappingsResource getUserClientRoleMappingsResource(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Client not found");
        }
        ClientRoleMappingsResource resource = new ClientRoleMappingsResource((UriInfo)this.session.getContext().getUri(), this.session, this.realm, this.auth, this.roleMapper, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
        return resource;
    }
}

