/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.StackUtil;
import org.keycloak.component.ComponentFactoryProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentModelScope;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public class DefaultComponentFactoryProviderFactory
implements ComponentFactoryProviderFactory {
    private static final Logger LOG = Logger.getLogger(DefaultComponentFactoryProviderFactory.class);
    public static final String PROVIDER_ID = "default";
    private final AtomicReference<ConcurrentMap<String, ProviderFactory>> componentsMap = new AtomicReference(new ConcurrentHashMap());
    private final ConcurrentMap<Object, Set<String>> dependentInvalidations = new ConcurrentHashMap<Object, Set<String>>();
    private KeycloakSessionFactory factory;
    private boolean componentCachingAvailable;
    private boolean componentCachingEnabled;
    private Boolean componentCachingForced;

    public void init(Config.Scope config) {
        this.componentCachingEnabled = config.getBoolean("cachingEnabled", Boolean.valueOf(true));
        this.componentCachingForced = config.getBoolean("cachingForced", Boolean.valueOf(false));
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.factory = factory;
        boolean bl = this.componentCachingAvailable = this.componentCachingEnabled && this.factory.getProviderFactory(ClusterProvider.class) != null;
        if (!this.componentCachingEnabled) {
            LOG.warn((Object)"Caching of components disabled by the configuration which may have performance impact.");
        } else if (!this.componentCachingAvailable) {
            if (Objects.equals(this.componentCachingForced, Boolean.TRUE)) {
                LOG.warn((Object)"Component caching forced even though no system-wide ClusterProviderFactory found. This would be only reliable in single-node deployment.");
                this.componentCachingAvailable = true;
            } else {
                LOG.warn((Object)"No system-wide ClusterProviderFactory found. Cannot send messages across cluster, thus disabling caching of components. Consider setting cachingForced option in single-node deployment.");
            }
        }
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String realmId, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        ProviderFactory newFactory;
        ProviderFactory pf;
        ComponentModel cm;
        ProviderFactory res = (ProviderFactory)this.componentsMap.get().get(componentId);
        if (res != null) {
            LOG.tracef("Found cached ProviderFactory for %s in (%s, %s)", clazz, (Object)realmId, (Object)componentId);
            return res;
        }
        if (modelGetter == null) {
            LOG.debugf("Getting component configuration for component (%s, %s) from realm configuration", clazz, (Object)realmId, (Object)componentId);
            cm = KeycloakModelUtils.getComponentModel((KeycloakSessionFactory)this.factory, (String)realmId, (String)componentId);
        } else {
            LOG.debugf("Getting component configuration for component (%s, %s) via provided method", (Object)realmId, (Object)componentId);
            cm = modelGetter.apply(this.factory);
        }
        if (cm == null) {
            return null;
        }
        String provider = cm.getProviderId();
        ProviderFactory providerFactory = pf = provider == null ? this.factory.getProviderFactory(clazz) : this.factory.getProviderFactory(clazz, provider);
        if (pf == null) {
            LOG.debugf("ProviderFactory for %s in (%s, %s) not found", clazz, (Object)realmId, (Object)componentId);
            return null;
        }
        try {
            newFactory = (ProviderFactory)pf.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            LOG.warn((Object)"Cannot instantiate factory", (Throwable)ex);
            return null;
        }
        Config.Scope scope = Config.scope((String[])new String[]{this.factory.getSpi(clazz).getName(), provider});
        ComponentModelScope configScope = new ComponentModelScope(scope, cm);
        ProviderFactory providerFactory2 = this.componentCachingAvailable ? this.componentsMap.get().computeIfAbsent(componentId, cId -> this.initializeFactory(clazz, realmId, componentId, newFactory, configScope)) : this.initializeFactory(clazz, realmId, componentId, newFactory, configScope);
        return providerFactory2;
    }

    protected <T extends Provider> ProviderFactory<T> initializeFactory(Class<T> clazz, String realmId, String componentId, ProviderFactory newFactory, ComponentModelScope configScope) {
        LOG.debugf("Initializing ProviderFactory for %s in (%s, %s)", clazz, (Object)realmId, (Object)componentId);
        newFactory.init((Config.Scope)configScope);
        newFactory.postInit(this.factory);
        if (realmId == null) {
            realmId = configScope.getComponentParentId();
        }
        if (realmId != null) {
            this.dependentInvalidations.computeIfAbsent(realmId, k -> ConcurrentHashMap.newKeySet()).add(componentId);
        }
        this.dependentInvalidations.computeIfAbsent(newFactory.getClass(), k -> ConcurrentHashMap.newKeySet()).add(componentId);
        return newFactory;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invalidate(InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Invalidating %s: %s", (Object)type, Arrays.asList(ids));
        }
        LOG.tracef("invalidate(%s)%s", (Object)type, StackUtil.getShortStackTrace());
        if (type == InvalidationHandler.ObjectType._ALL_) {
            ConcurrentMap cm = this.componentsMap.getAndSet(new ConcurrentHashMap());
            this.dependentInvalidations.clear();
            cm.values().forEach(ProviderFactory::close);
            return;
        }
        if (type == InvalidationHandler.ObjectType.COMPONENT) {
            Stream.of(ids).map(this.componentsMap.get()::remove).filter(Objects::nonNull).forEach(ProviderFactory::close);
            this.propagateInvalidation(this.componentsMap.get(), type, ids);
            return;
        }
        if (type != InvalidationHandler.ObjectType.REALM && type != InvalidationHandler.ObjectType.PROVIDER_FACTORY) {
            this.propagateInvalidation(this.componentsMap.get(), type, ids);
            return;
        }
        Stream.of(ids).map(this.dependentInvalidations::get).filter(Objects::nonNull).flatMap(Collection::stream).map(this.componentsMap.get()::remove).filter(Objects::nonNull).forEach(ProviderFactory::close);
        Stream.of(ids).forEach(this.dependentInvalidations::remove);
        this.propagateInvalidation(this.componentsMap.get(), type, ids);
    }

    private void propagateInvalidation(ConcurrentMap<String, ProviderFactory> componentsMap, InvalidationHandler.InvalidableObjectType type, Object[] ids) {
        componentsMap.values().stream().filter(InvalidationHandler.class::isInstance).map(InvalidationHandler.class::cast).forEach(ih -> ih.invalidate(type, ids));
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void close() {
        this.componentsMap.get().values().forEach(ProviderFactory::close);
    }
}

