/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.authentication.requiredactions.UpdateTotp;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class OTPFormAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator,
CredentialValidator<OTPCredentialProvider> {
    public static final String SELECTED_OTP_CREDENTIAL_ID = "selectedOtpCredentialId";
    public static final String UNNAMED = "unnamed";

    @Override
    public void action(AuthenticationFlowContext context) {
        this.validateOTP(context);
    }

    public void authenticate(AuthenticationFlowContext context) {
        Response challengeResponse = this.challenge(context, null);
        context.challenge(challengeResponse);
    }

    public void validateOTP(AuthenticationFlowContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        String otp = (String)inputData.getFirst((Object)"otp");
        String credentialId = (String)inputData.getFirst((Object)"selectedCredentialId");
        if (credentialId == null || credentialId.isEmpty()) {
            OTPCredentialModel defaultOtpCredential = (OTPCredentialModel)this.getCredentialProvider(context.getSession()).getDefaultCredential(context.getSession(), context.getRealm(), context.getUser());
            credentialId = defaultOtpCredential == null ? "" : defaultOtpCredential.getId();
        }
        context.getEvent().detail("selected_credential_id", credentialId);
        context.form().setAttribute(SELECTED_OTP_CREDENTIAL_ID, (Object)credentialId);
        UserModel userModel = context.getUser();
        if (!this.enabledUser(context, userModel)) {
            return;
        }
        if (otp == null) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        boolean valid = context.getSession().userCredentialManager().isValid(context.getRealm(), context.getUser(), new CredentialInput[]{new UserCredentialModel(credentialId, this.getCredentialProvider(context.getSession()).getType(), otp)});
        if (!valid) {
            context.getEvent().user(userModel).error("invalid_user_credentials");
            Response challengeResponse = this.challenge(context, "invalidTotpMessage", "totp");
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    public boolean requiresUser() {
        return true;
    }

    @Override
    protected String disabledByBruteForceError() {
        return "invalidTotpMessage";
    }

    @Override
    protected String disabledByBruteForceFieldError() {
        return "totp";
    }

    @Override
    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginTotp();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, this.getCredentialProvider(session).getType());
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (!authenticationSession.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP.name())) {
            authenticationSession.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((UpdateTotp)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, UserModel.RequiredAction.CONFIGURE_TOTP.name()));
    }

    @Override
    public void close() {
    }

    public OTPCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
    }
}

