/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints.request;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.request.BackchannelAuthenticationEndpointRequest;

public abstract class BackchannelAuthenticationEndpointRequestParser {
    private static final Logger logger = Logger.getLogger(BackchannelAuthenticationEndpointRequestParser.class);
    public static final int ADDITIONAL_REQ_PARAMS_MAX_MUMBER = 5;
    public static final int ADDITIONAL_REQ_PARAMS_MAX_SIZE = 200;
    public static final String CIBA_SIGNED_AUTHENTICATION_REQUEST = "ParsedSignedAuthenticationRequest";
    public static final Set<String> KNOWN_REQ_PARAMS = new HashSet<String>();

    public void parseRequest(BackchannelAuthenticationEndpointRequest request) {
        request.scope = this.replaceIfNotNull(request.scope, this.getParameter("scope"));
        request.clientNotificationToken = this.replaceIfNotNull(request.clientNotificationToken, this.getParameter("client_notification_token"));
        request.acr = this.replaceIfNotNull(request.acr, this.getParameter("acr_values"));
        request.loginHintToken = this.replaceIfNotNull(request.loginHintToken, this.getParameter("login_hint_token"));
        request.idTokenHint = this.replaceIfNotNull(request.idTokenHint, this.getParameter("id_token_hint"));
        request.loginHint = this.replaceIfNotNull(request.loginHint, this.getParameter("login_hint"));
        request.bindingMessage = this.replaceIfNotNull(request.bindingMessage, this.getParameter("binding_message"));
        request.userCode = this.replaceIfNotNull(request.userCode, this.getParameter("user_code"));
        request.requestedExpiry = this.replaceIfNotNull(request.requestedExpiry, this.getIntParameter("requested_expiry"));
        request.prompt = this.replaceIfNotNull(request.prompt, this.getParameter("prompt"));
        request.nonce = this.replaceIfNotNull(request.nonce, this.getParameter("nonce"));
        request.maxAge = this.replaceIfNotNull(request.maxAge, this.getIntParameter("max_age"));
        request.uiLocales = this.replaceIfNotNull(request.uiLocales, this.getParameter("ui_locales"));
        request.claims = this.replaceIfNotNull(request.claims, this.getParameter("claims"));
        this.extractAdditionalReqParams(request.additionalReqParams);
    }

    protected void extractAdditionalReqParams(Map<String, String> additionalReqParams) {
        for (String paramName : this.keySet()) {
            if (KNOWN_REQ_PARAMS.contains(paramName)) continue;
            String value = this.getParameter(paramName);
            if (value != null && value.trim().isEmpty()) {
                value = null;
            }
            if (value != null && value.length() <= 200) {
                if (additionalReqParams.size() >= 5) {
                    logger.debug((Object)"Maximal number of additional OIDC CIBA params (5) exceeded, ignoring rest of them!");
                    break;
                }
                additionalReqParams.put(paramName, value);
                continue;
            }
            logger.debug((Object)("OIDC CIBA Additional param " + paramName + " ignored because value is empty or longer than " + 200));
        }
    }

    protected <T> T replaceIfNotNull(T previousVal, T newVal) {
        return newVal == null ? previousVal : newVal;
    }

    protected abstract String getParameter(String var1);

    protected abstract Integer getIntParameter(String var1);

    protected abstract Set<String> keySet();

    static {
        KNOWN_REQ_PARAMS.add("request");
        KNOWN_REQ_PARAMS.add("request_uri");
        KNOWN_REQ_PARAMS.add("scope");
        KNOWN_REQ_PARAMS.add("client_notification_token");
        KNOWN_REQ_PARAMS.add("acr_values");
        KNOWN_REQ_PARAMS.add("login_hint_token");
        KNOWN_REQ_PARAMS.add("id_token_hint");
        KNOWN_REQ_PARAMS.add("login_hint");
        KNOWN_REQ_PARAMS.add("binding_message");
        KNOWN_REQ_PARAMS.add("user_code");
        KNOWN_REQ_PARAMS.add("requested_expiry");
        KNOWN_REQ_PARAMS.add("prompt");
        KNOWN_REQ_PARAMS.add("nonce");
        KNOWN_REQ_PARAMS.add("max_age");
        KNOWN_REQ_PARAMS.add("ui_locales");
        KNOWN_REQ_PARAMS.add("claims");
    }
}

