/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialMetadata;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.models.credential.dto.RecoveryAuthnCodeRepresentation;
import org.keycloak.models.credential.dto.RecoveryAuthnCodesCredentialData;
import org.keycloak.models.utils.RecoveryAuthnCodesUtils;
import org.keycloak.util.JsonSerialization;

public class RecoveryAuthnCodesCredentialProvider
implements CredentialProvider<RecoveryAuthnCodesCredentialModel>,
CredentialInputValidator {
    private static final Logger logger = Logger.getLogger(RecoveryAuthnCodesCredentialProvider.class);
    private final KeycloakSession session;

    public RecoveryAuthnCodesCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public String getType() {
        return "recovery-authn-codes";
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, RecoveryAuthnCodesCredentialModel credentialModel) {
        this.session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, this.getType()).findFirst().ifPresent(model -> this.deleteCredential(realm, user, model.getId()));
        return this.session.userCredentialManager().createCredential(realm, user, (CredentialModel)credentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return this.session.userCredentialManager().removeStoredCredential(realm, user, credentialId);
    }

    public RecoveryAuthnCodesCredentialModel getCredentialFromModel(CredentialModel model) {
        return RecoveryAuthnCodesCredentialModel.createFromCredentialModel((CredentialModel)model);
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        CredentialTypeMetadata.CredentialTypeMetadataBuilder builder = CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("recovery-authn-codes-display-name").helpText("recovery-authn-codes-help-text").iconCssClass("kcAuthenticatorRecoveryAuthnCodesClass").removeable(true);
        UserModel user = metadataContext.getUser();
        builder.createAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name());
        return builder.build(this.session);
    }

    public CredentialMetadata getCredentialMetadata(RecoveryAuthnCodesCredentialModel credentialModel, CredentialTypeMetadata credentialTypeMetadata) {
        CredentialMetadata credentialMetadata = new CredentialMetadata();
        try {
            RecoveryAuthnCodesCredentialData credentialData = (RecoveryAuthnCodesCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), RecoveryAuthnCodesCredentialData.class);
            if (credentialData.getRemainingCodes() < this.getWarningThreshold()) {
                credentialMetadata.setWarningMessageTitle("recovery-codes-number-remaining", new String[]{String.valueOf(credentialData.getRemainingCodes())});
                credentialMetadata.setWarningMessageDescription("recovery-codes-generate-new-codes", new String[0]);
            }
            int codesUsed = credentialData.getTotalCodes() - credentialData.getRemainingCodes();
            String codesUsedMessage = codesUsed + "/" + credentialData.getTotalCodes();
            credentialMetadata.setInfoMessage("recovery-codes-number-used", new String[]{codesUsedMessage});
        }
        catch (IOException e) {
            logger.warn((Object)"unable to deserialize model information, skipping messages", (Throwable)e);
        }
        credentialMetadata.setCredentialModel((CredentialModel)credentialModel);
        return credentialMetadata;
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, credentialType).anyMatch(Objects::nonNull);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput credentialInput) {
        String nextRecoveryCode;
        Optional nextRecoveryAuthnCode;
        RecoveryAuthnCodesCredentialModel credentialModel;
        String rawInputRecoveryAuthnCode = credentialInput.getChallengeResponse();
        Optional credential = this.session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, this.getType()).findFirst();
        if (credential.isPresent() && !(credentialModel = RecoveryAuthnCodesCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)credential.get()))).allCodesUsed() && (nextRecoveryAuthnCode = credentialModel.getNextRecoveryAuthnCode()).isPresent() && RecoveryAuthnCodesUtils.verifyRecoveryCodeInput((String)rawInputRecoveryAuthnCode, (String)(nextRecoveryCode = ((RecoveryAuthnCodeRepresentation)nextRecoveryAuthnCode.get()).getEncodedHashedValue()))) {
            credentialModel.removeRecoveryAuthnCode();
            this.session.userCredentialManager().updateCredential(realm, user, (CredentialModel)credentialModel);
            return true;
        }
        return false;
    }

    protected int getWarningThreshold() {
        return this.session.getContext().getRealm().getPasswordPolicy().getRecoveryCodesWarningThreshold();
    }
}

