/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.ExistingUserInfo;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public class IdpConfirmLinkAuthenticator
extends AbstractIdpAuthenticator {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        ClientSessionModel clientSession = context.getClientSession();
        String existingUserInfo = clientSession.getNote("EXISTING_USER_INFO");
        if (existingUserInfo == null) {
            logger.noDuplicationDetected();
            context.attempted();
            return;
        }
        ExistingUserInfo duplicationInfo = ExistingUserInfo.deserialize(existingUserInfo);
        Response challenge = context.form().setStatus(Response.Status.OK).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).setError("federatedIdentityConfirmLinkMessage", new Object[]{duplicationInfo.getDuplicateAttributeName(), duplicationInfo.getDuplicateAttributeValue()}).createIdpLinkConfirmLinkPage();
        context.challenge(challenge);
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String action = (String)formData.getFirst((Object)"submitAction");
        if (action != null && action.equals("updateProfile")) {
            context.getClientSession().setNote("ENFORCE_UPDATE_PROFILE", "true");
            context.getClientSession().removeNote("EXISTING_USER_INFO");
            context.resetFlow();
        } else if (action != null && action.equals("linkAccount")) {
            context.success();
        } else {
            throw new AuthenticationFlowException("Unknown action: " + action, AuthenticationFlowError.INTERNAL_ERROR);
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }
}

