/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.clientregistration.oidc.DescriptionConverter;

public class OIDCClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public OIDCClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOIDC(OIDCClientRepresentation clientOIDC) {
        if (clientOIDC.getClientId() != null) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier included", Response.Status.BAD_REQUEST);
        }
        try {
            ClientRepresentation client = DescriptionConverter.toInternal(clientOIDC);
            client = this.create(client);
            URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
            clientOIDC = DescriptionConverter.toExternalResponse(client, uri);
            clientOIDC.setClientIdIssuedAt(Integer.valueOf(Time.currentTime()));
            return Response.created((URI)uri).entity((Object)clientOIDC).build();
        }
        catch (ClientRegistrationException cre) {
            logger.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response getOIDC(@PathParam(value="clientId") String clientId) {
        ClientRepresentation client = this.get(clientId);
        OIDCClientRepresentation clientOIDC = DescriptionConverter.toExternalResponse(client, this.session.getContext().getUri().getRequestUri());
        return Response.ok((Object)clientOIDC).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    public Response updateOIDC(@PathParam(value="clientId") String clientId, OIDCClientRepresentation clientOIDC) {
        try {
            ClientRepresentation client = DescriptionConverter.toInternal(clientOIDC);
            client = this.update(clientId, client);
            URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
            clientOIDC = DescriptionConverter.toExternalResponse(client, uri);
            return Response.ok((Object)clientOIDC).build();
        }
        catch (ClientRegistrationException cre) {
            logger.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @DELETE
    @Path(value="{clientId}")
    public void deleteOIDC(@PathParam(value="clientId") String clientId) {
        this.delete(clientId);
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public void close() {
    }
}

