/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.admin.ScopeService;
import org.keycloak.authorization.admin.representation.PolicyRepresentation;
import org.keycloak.authorization.admin.representation.ResourceOwnerRepresentation;
import org.keycloak.authorization.admin.representation.ResourceRepresentation;
import org.keycloak.authorization.admin.representation.ResourceServerRepresentation;
import org.keycloak.authorization.admin.representation.ScopeRepresentation;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationManager;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.util.JsonSerialization;

public class ResourceServerService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private ResourceServer resourceServer;
    private final ClientModel client;

    public ResourceServerService(AuthorizationProvider authorization, ResourceServer resourceServer, ClientModel client, RealmAuth auth) {
        this.authorization = authorization;
        this.session = authorization.getKeycloakSession();
        this.client = client;
        this.resourceServer = resourceServer;
        this.realm = client.getRealm();
        this.auth = auth;
    }

    public void create() {
        this.auth.requireManage();
        this.resourceServer = this.authorization.getStoreFactory().getResourceServerStore().create(this.client.getId());
        this.createDefaultRoles();
        this.createDefaultPermission(this.createDefaultResource(), this.createDefaultPolicy());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(ResourceServerRepresentation server) {
        this.auth.requireManage();
        this.resourceServer.setAllowRemoteResourceManagement(server.isAllowRemoteResourceManagement());
        this.resourceServer.setPolicyEnforcementMode(server.getPolicyEnforcementMode());
        return Response.noContent().build();
    }

    public void delete() {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        String id = this.resourceServer.getId();
        resourceStore.findByResourceServer(id).forEach(resource -> resourceStore.delete(resource.getId()));
        ScopeStore scopeStore = storeFactory.getScopeStore();
        scopeStore.findByResourceServer(id).forEach(scope -> scopeStore.delete(scope.getId()));
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policyStore.findByResourceServer(id).forEach(scope -> policyStore.delete(scope.getId()));
        storeFactory.getResourceServerStore().delete(id);
    }

    @GET
    @Produces(value={"application/json"})
    public Response findById() {
        this.auth.requireView();
        return Response.ok((Object)Models.toRepresentation(this.resourceServer, this.realm)).build();
    }

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    public Response exportSettings() {
        this.auth.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceServerRepresentation settings = Models.toRepresentation(this.resourceServer, this.realm);
        settings.setId(null);
        settings.setName(null);
        settings.setClientId(null);
        List<ResourceRepresentation> resources = storeFactory.getResourceStore().findByResourceServer(this.resourceServer.getId()).stream().map(resource -> {
            ResourceRepresentation rep = Models.toRepresentation(resource, this.resourceServer, this.authorization);
            rep.getOwner().setId(null);
            rep.setId(null);
            rep.setPolicies(null);
            rep.getScopes().forEach(scopeRepresentation -> {
                scopeRepresentation.setId(null);
                scopeRepresentation.setIconUri(null);
            });
            return rep;
        }).collect(Collectors.toList());
        settings.setResources(resources);
        ArrayList<PolicyRepresentation> policies = new ArrayList<PolicyRepresentation>();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policies.addAll(policyStore.findByResourceServer(this.resourceServer.getId()).stream().filter(policy -> !policy.getType().equals("resource") && !policy.getType().equals("scope")).map(policy -> this.createPolicyRepresentation(storeFactory, (Policy)policy)).collect(Collectors.toList()));
        policies.addAll(policyStore.findByResourceServer(this.resourceServer.getId()).stream().filter(policy -> policy.getType().equals("resource") || policy.getType().equals("scope")).map(policy -> this.createPolicyRepresentation(storeFactory, (Policy)policy)).collect(Collectors.toList()));
        settings.setPolicies(policies);
        List<ScopeRepresentation> scopes = storeFactory.getScopeStore().findByResourceServer(this.resourceServer.getId()).stream().map(scope -> {
            ScopeRepresentation rep = Models.toRepresentation(scope, this.authorization);
            rep.setId(null);
            rep.getPolicies().forEach(policyRepresentation -> {
                policyRepresentation.setId(null);
                policyRepresentation.setConfig(null);
                policyRepresentation.setType(null);
                policyRepresentation.setDecisionStrategy(null);
                policyRepresentation.setDescription(null);
                policyRepresentation.setDependentPolicies(null);
            });
            return rep;
        }).collect(Collectors.toList());
        settings.setScopes(scopes);
        return Response.ok((Object)settings).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response importSettings(@Context UriInfo uriInfo, MultipartFormDataInput input) throws IOException {
        this.auth.requireManage();
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        for (InputPart inputPart : inputParts) {
            ResourceServerRepresentation rep = (ResourceServerRepresentation)JsonSerialization.readValue((String)inputPart.getBodyAsString(), ResourceServerRepresentation.class);
            this.resourceServer.setPolicyEnforcementMode(rep.getPolicyEnforcementMode());
            this.resourceServer.setAllowRemoteResourceManagement(rep.isAllowRemoteResourceManagement());
            StoreFactory storeFactory = this.authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            ScopeStore scopeStore = storeFactory.getScopeStore();
            ScopeService scopeResource = new ScopeService(this.resourceServer, this.authorization, this.auth);
            ResteasyProviderFactory.getInstance().injectProperties((Object)scopeResource);
            rep.getScopes().forEach(scope -> {
                Scope existing = scopeStore.findByName(scope.getName(), this.resourceServer.getId());
                if (existing != null) {
                    scopeResource.update(existing.getId(), (ScopeRepresentation)scope);
                } else {
                    scopeResource.create((ScopeRepresentation)scope);
                }
            });
            ResourceSetService resourceSetResource = new ResourceSetService(this.resourceServer, this.authorization, this.auth);
            rep.getResources().forEach(resourceRepresentation -> {
                Resource existing;
                UserModel user;
                ResourceOwnerRepresentation owner = resourceRepresentation.getOwner();
                if (owner == null) {
                    owner = new ResourceOwnerRepresentation();
                }
                owner.setId(this.resourceServer.getClientId());
                if (owner.getName() != null && (user = this.session.users().getUserByUsername(owner.getName(), this.realm)) != null) {
                    owner.setId(user.getId());
                }
                if ((existing = resourceStore.findByName(resourceRepresentation.getName(), this.resourceServer.getId())) != null) {
                    resourceSetResource.update(existing.getId(), (ResourceRepresentation)resourceRepresentation);
                } else {
                    resourceSetResource.create((ResourceRepresentation)resourceRepresentation);
                }
            });
            PolicyStore policyStore = storeFactory.getPolicyStore();
            PolicyService policyResource = new PolicyService(this.resourceServer, this.authorization, this.auth);
            ResteasyProviderFactory.getInstance().injectProperties((Object)policyResource);
            rep.getPolicies().forEach(policyRepresentation -> {
                Policy existing;
                String applyPolicies;
                String policyResources;
                String scopes;
                String users;
                Map<String, String> config = policyRepresentation.getConfig();
                String roles = config.get("roles");
                if (roles != null && !roles.isEmpty()) {
                    roles = roles.replace("[", "");
                    if (!(roles = roles.replace("]", "")).isEmpty()) {
                        String roleNames = "";
                        for (String role : roles.split(",")) {
                            if (!roleNames.isEmpty()) {
                                roleNames = roleNames + ",";
                            }
                            role = role.replace("\"", "");
                            roleNames = roleNames + "\"" + this.realm.getRole(role).getId() + "\"";
                        }
                        config.put("roles", "[" + roleNames + "]");
                    }
                }
                if ((users = config.get("users")) != null) {
                    users = users.replace("[", "");
                    if (!(users = users.replace("]", "")).isEmpty()) {
                        String userNames = "";
                        for (String user : users.split(",")) {
                            if (!userNames.isEmpty()) {
                                userNames = userNames + ",";
                            }
                            user = user.replace("\"", "");
                            userNames = userNames + "\"" + this.session.users().getUserByUsername(user, this.realm).getId() + "\"";
                        }
                        config.put("users", "[" + userNames + "]");
                    }
                }
                if ((scopes = config.get("scopes")) != null && !scopes.isEmpty()) {
                    scopes = scopes.replace("[", "");
                    if (!(scopes = scopes.replace("]", "")).isEmpty()) {
                        String scopeNames = "";
                        for (String scope : scopes.split(",")) {
                            Scope newScope;
                            if (!scopeNames.isEmpty()) {
                                scopeNames = scopeNames + ",";
                            }
                            if ((newScope = scopeStore.findByName(scope = scope.replace("\"", ""), this.resourceServer.getId())) == null) {
                                throw new RuntimeException("Scope with name [" + scope + "] not defined.");
                            }
                            scopeNames = scopeNames + "\"" + newScope.getId() + "\"";
                        }
                        config.put("scopes", "[" + scopeNames + "]");
                    }
                }
                if ((policyResources = config.get("resources")) != null && !policyResources.isEmpty()) {
                    policyResources = policyResources.replace("[", "");
                    if (!(policyResources = policyResources.replace("]", "")).isEmpty()) {
                        String resourceNames = "";
                        for (String resource : policyResources.split(",")) {
                            if (!resourceNames.isEmpty()) {
                                resourceNames = resourceNames + ",";
                            }
                            if ("".equals(resource = resource.replace("\"", ""))) continue;
                            resourceNames = resourceNames + "\"" + storeFactory.getResourceStore().findByName(resource, this.resourceServer.getId()).getId() + "\"";
                        }
                        config.put("resources", "[" + resourceNames + "]");
                    }
                }
                if ((applyPolicies = config.get("applyPolicies")) != null && !applyPolicies.isEmpty()) {
                    applyPolicies = applyPolicies.replace("[", "");
                    if (!(applyPolicies = applyPolicies.replace("]", "")).isEmpty()) {
                        String policyNames = "";
                        for (String pId : applyPolicies.split(",")) {
                            Policy policy;
                            if (!policyNames.isEmpty()) {
                                policyNames = policyNames + ",";
                            }
                            if ((policy = policyStore.findByName(pId = pId.replace("\"", "").trim(), this.resourceServer.getId())) == null) {
                                throw new RuntimeException("Policy with name [" + pId + "] not defined.");
                            }
                            policyNames = policyNames + "\"" + policy.getId() + "\"";
                        }
                        config.put("applyPolicies", "[" + policyNames + "]");
                    }
                }
                if ((existing = policyStore.findByName(policyRepresentation.getName(), this.resourceServer.getId())) != null) {
                    policyResource.update(existing.getId(), (PolicyRepresentation)policyRepresentation);
                } else {
                    policyResource.create((PolicyRepresentation)policyRepresentation);
                }
            });
        }
        return Response.noContent().build();
    }

    @Path(value="/resource")
    public ResourceSetService getResourceSetResource() {
        ResourceSetService resource = new ResourceSetService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/scope")
    public ScopeService getScopeResource() {
        ScopeService resource = new ScopeService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/policy")
    public PolicyService getPolicyResource() {
        PolicyService resource = new PolicyService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private void createDefaultPermission(ResourceRepresentation resource, PolicyRepresentation policy) {
        PolicyRepresentation defaultPermission = new PolicyRepresentation();
        defaultPermission.setName("Default Permission");
        defaultPermission.setType("resource");
        defaultPermission.setDescription("A permission that applies to the default resource type");
        defaultPermission.setDecisionStrategy(Policy.DecisionStrategy.UNANIMOUS);
        defaultPermission.setLogic(Policy.Logic.POSITIVE);
        HashMap<String, String> defaultPermissionConfig = new HashMap<String, String>();
        defaultPermissionConfig.put("default", "true");
        defaultPermissionConfig.put("defaultResourceType", resource.getType());
        defaultPermissionConfig.put("applyPolicies", "[\"" + policy.getName() + "\"]");
        defaultPermission.setConfig(defaultPermissionConfig);
        this.getPolicyResource().create(defaultPermission);
    }

    private PolicyRepresentation createDefaultPolicy() {
        PolicyRepresentation defaultPolicy = new PolicyRepresentation();
        defaultPolicy.setName("Only From Realm Policy");
        defaultPolicy.setDescription("A policy that grants access only for users within this realm");
        defaultPolicy.setType("js");
        defaultPolicy.setDecisionStrategy(Policy.DecisionStrategy.AFFIRMATIVE);
        defaultPolicy.setLogic(Policy.Logic.POSITIVE);
        HashMap<String, String> defaultPolicyConfig = new HashMap<String, String>();
        defaultPolicyConfig.put("code", "var context = $evaluation.getContext();\n\n// using attributes from the evaluation context to obtain the realm\nvar contextAttributes = context.getAttributes();\nvar realmName = contextAttributes.getValue('kc.realm.name').asString(0);\n\n// using attributes from the identity to obtain the issuer\nvar identity = context.getIdentity();\nvar identityAttributes = identity.getAttributes();\nvar issuer = identityAttributes.getValue('iss').asString(0);\n\n// only users from the realm have access granted \nif (issuer.endsWith(realmName)) {\n    $evaluation.grant();\n}");
        defaultPolicy.setConfig(defaultPolicyConfig);
        this.getPolicyResource().create(defaultPolicy);
        return defaultPolicy;
    }

    private ResourceRepresentation createDefaultResource() {
        ResourceRepresentation defaultResource = new ResourceRepresentation();
        defaultResource.setName("Default Resource");
        defaultResource.setUri("/*");
        defaultResource.setType("urn:" + this.client.getClientId() + ":resources:default");
        this.getResourceSetResource().create(defaultResource);
        return defaultResource;
    }

    private void createDefaultRoles() {
        UserModel serviceAccount;
        RoleModel umaProtectionRole = this.client.getRole("uma_protection");
        if (umaProtectionRole == null) {
            umaProtectionRole = this.client.addRole("uma_protection");
        }
        if (!(serviceAccount = this.session.users().getUserByServiceAccountClient(this.client)).hasRole(umaProtectionRole)) {
            serviceAccount.grantRole(umaProtectionRole);
        }
    }

    private PolicyRepresentation createPolicyRepresentation(StoreFactory storeFactory, Policy policy) {
        String policyResources;
        String scopes;
        String users;
        PolicyRepresentation rep = Models.toRepresentation(policy, this.authorization);
        rep.setId(null);
        rep.setDependentPolicies(null);
        Map<String, String> config = rep.getConfig();
        String roles = config.get("roles");
        if (roles != null && !roles.isEmpty()) {
            roles = roles.replace("[", "");
            if (!(roles = roles.replace("]", "")).isEmpty()) {
                String roleNames = "";
                for (String role : roles.split(",")) {
                    if (!roleNames.isEmpty()) {
                        roleNames = roleNames + ",";
                    }
                    role = role.replace("\"", "");
                    roleNames = roleNames + "\"" + this.realm.getRoleById(role).getName() + "\"";
                }
                config.put("roles", "[" + roleNames + "]");
            }
        }
        if ((users = config.get("users")) != null) {
            users = users.replace("[", "");
            if (!(users = users.replace("]", "")).isEmpty()) {
                UserFederationManager userManager = this.session.users();
                String userNames = "";
                for (String user : users.split(",")) {
                    if (!userNames.isEmpty()) {
                        userNames = userNames + ",";
                    }
                    user = user.replace("\"", "");
                    userNames = userNames + "\"" + userManager.getUserById(user, this.realm).getUsername() + "\"";
                }
                config.put("users", "[" + userNames + "]");
            }
        }
        if ((scopes = config.get("scopes")) != null && !scopes.isEmpty()) {
            scopes = scopes.replace("[", "");
            if (!(scopes = scopes.replace("]", "")).isEmpty()) {
                ScopeStore scopeStore = storeFactory.getScopeStore();
                String scopeNames = "";
                for (String scope : scopes.split(",")) {
                    if (!scopeNames.isEmpty()) {
                        scopeNames = scopeNames + ",";
                    }
                    scope = scope.replace("\"", "");
                    scopeNames = scopeNames + "\"" + scopeStore.findById(scope).getName() + "\"";
                }
                config.put("scopes", "[" + scopeNames + "]");
            }
        }
        if ((policyResources = config.get("resources")) != null && !policyResources.isEmpty()) {
            policyResources = policyResources.replace("[", "");
            if (!(policyResources = policyResources.replace("]", "")).isEmpty()) {
                ResourceStore resourceStore = storeFactory.getResourceStore();
                String resourceNames = "";
                for (String resource : policyResources.split(",")) {
                    if (!resourceNames.isEmpty()) {
                        resourceNames = resourceNames + ",";
                    }
                    resource = resource.replace("\"", "");
                    resourceNames = resourceNames + "\"" + resourceStore.findById(resource).getName() + "\"";
                }
                config.put("resources", "[" + resourceNames + "]");
            }
        }
        String policyNames = "";
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (!associatedPolicies.isEmpty()) {
            for (Policy associatedPolicy : associatedPolicies) {
                if (!policyNames.isEmpty()) {
                    policyNames = policyNames + ",";
                }
                policyNames = policyNames + "\"" + associatedPolicy.getName() + "\"";
            }
            config.put("applyPolicies", "[" + policyNames + "]");
        }
        return rep;
    }
}

