/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.entitlement;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.entitlement.representation.EntitlementRequest;
import org.keycloak.authorization.entitlement.representation.EntitlementResponse;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.authorization.Permission;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;

public class EntitlementService {
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest request;

    public EntitlementService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @Path(value="{resource_server_id}")
    @OPTIONS
    public Response authorizePreFlight(@PathParam(value="resource_server_id") String resourceServerId) {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="{resource_server_id}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void getAll(@PathParam(value="resource_server_id") String resourceServerId, final @Suspended AsyncResponse asyncResponse) {
        final KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        if (resourceServerId == null) {
            throw new ErrorResponseException("invalid_request", "Requires resource_server_id request parameter.", Response.Status.BAD_REQUEST);
        }
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel client = realm.getClientByClientId(resourceServerId);
        if (client == null) {
            throw new ErrorResponseException("invalid_request", "Identifier is not associated with any client and resource server.", Response.Status.BAD_REQUEST);
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(client.getId());
        this.authorization.evaluators().from(Permissions.all(resourceServer, identity, this.authorization), (EvaluationContext)new KeycloakEvaluationContext(this.authorization.getKeycloakSession())).evaluate((Decision)new DecisionResultCollector(){

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }

            protected void onComplete(List<Result> results) {
                List<Permission> entitlements = Permissions.allPermits(results);
                if (entitlements.isEmpty()) {
                    asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorResponseException("not_authorized", "Authorization denied.", Response.Status.FORBIDDEN))).allowedOrigins(identity.getAccessToken()).exposedHeaders("Access-Control-Allow-Methods").build());
                } else {
                    asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.ok().entity((Object)new EntitlementResponse(EntitlementService.this.createRequestingPartyToken(entitlements)))).allowedOrigins(identity.getAccessToken()).allowedMethods("GET").exposedHeaders("Access-Control-Allow-Methods").build());
                }
            }
        });
    }

    @Path(value="{resource_server_id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void get(@PathParam(value="resource_server_id") String resourceServerId, EntitlementRequest entitlementRequest, final @Suspended AsyncResponse asyncResponse) {
        final KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        if (entitlementRequest == null) {
            throw new ErrorResponseException("invalid_request", "Invalid entitlement request.", Response.Status.BAD_REQUEST);
        }
        if (resourceServerId == null) {
            throw new ErrorResponseException("invalid_request", "Invalid resource_server_id.", Response.Status.BAD_REQUEST);
        }
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel client = realm.getClientByClientId(resourceServerId);
        if (client == null) {
            throw new ErrorResponseException("invalid_request", "Identifier is not associated with any resource server.", Response.Status.BAD_REQUEST);
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(client.getId());
        this.authorization.evaluators().from(this.createPermissions(entitlementRequest, resourceServer, this.authorization), (EvaluationContext)new KeycloakEvaluationContext(this.authorization.getKeycloakSession())).evaluate((Decision)new DecisionResultCollector(){

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }

            protected void onComplete(List<Result> results) {
                List<Permission> entitlements = Permissions.allPermits(results);
                if (entitlements.isEmpty()) {
                    asyncResponse.resume((Throwable)((Object)new ErrorResponseException("not_authorized", "Authorization denied.", Response.Status.FORBIDDEN)));
                } else {
                    asyncResponse.resume((Object)Cors.add(EntitlementService.this.request, Response.ok().entity((Object)new EntitlementResponse(EntitlementService.this.createRequestingPartyToken(entitlements)))).allowedOrigins(identity.getAccessToken()).allowedMethods("GET").exposedHeaders("Access-Control-Allow-Methods").build());
                }
            }
        });
    }

    private String createRequestingPartyToken(List<Permission> permissions) {
        AccessToken accessToken = Tokens.getAccessToken(this.authorization.getKeycloakSession());
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(permissions);
        accessToken.setAuthorization(authorization);
        return new TokenManager().encodeToken(realm, accessToken);
    }

    private List<ResourcePermission> createPermissions(EntitlementRequest entitlementRequest, ResourceServer resourceServer, AuthorizationProvider authorization) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        HashMap permissionsToEvaluate = new HashMap();
        entitlementRequest.getPermissions().forEach(requestedResource -> {
            Resource resource = requestedResource.getResourceSetId() != null ? storeFactory.getResourceStore().findById(requestedResource.getResourceSetId()) : storeFactory.getResourceStore().findByName(requestedResource.getResourceSetName(), resourceServer.getId());
            if (resource == null) {
                throw new ErrorResponseException("invalid_resource", "Resource with id [" + requestedResource.getResourceSetId() + "] or name [" + requestedResource.getResourceSetName() + "] does not exist.", Response.Status.FORBIDDEN);
            }
            permissionsToEvaluate.put(resource.getId(), requestedResource.getScopes());
        });
        String rpt = entitlementRequest.getRpt();
        if (rpt != null && !"".equals(rpt)) {
            AccessToken.Authorization authorizationData;
            AccessToken requestingPartyToken;
            KeycloakContext context = authorization.getKeycloakSession().getContext();
            if (!Tokens.verifySignature(rpt, context.getRealm().getPublicKey())) {
                throw new ErrorResponseException("invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            try {
                requestingPartyToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new ErrorResponseException("invalid_rpt", "Invalid RPT", Response.Status.FORBIDDEN);
            }
            if (requestingPartyToken.isActive() && (authorizationData = requestingPartyToken.getAuthorization()) != null) {
                authorizationData.getPermissions().forEach(permission -> {
                    Resource resourcePermission = storeFactory.getResourceStore().findById(permission.getResourceSetId());
                    if (resourcePermission != null) {
                        HashSet scopes = (HashSet)permissionsToEvaluate.get(resourcePermission.getId());
                        if (scopes == null) {
                            scopes = new HashSet();
                            permissionsToEvaluate.put(resourcePermission.getId(), scopes);
                        }
                        scopes.addAll(permission.getScopes());
                    }
                });
            }
        }
        return permissionsToEvaluate.entrySet().stream().flatMap(entry -> {
            Resource entryResource = storeFactory.getResourceStore().findById((String)entry.getKey());
            if (((Set)entry.getValue()).isEmpty()) {
                return Arrays.asList(new ResourcePermission(entryResource, Collections.emptyList(), entryResource.getResourceServer())).stream();
            }
            return ((Set)entry.getValue()).stream().map(scopeName -> storeFactory.getScopeStore().findByName(scopeName, entryResource.getResourceServer().getId())).filter(scope -> scope != null).map(scope -> new ResourcePermission(entryResource, Arrays.asList(scope), entryResource.getResourceServer()));
        }).collect(Collectors.toList());
    }
}

