/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.BruteForceProtector;

public class DefaultBruteForceProtector
implements Runnable,
BruteForceProtector {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected volatile boolean run = true;
    protected int maxDeltaTimeSeconds = 43200;
    protected KeycloakSessionFactory factory;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected volatile long failures;
    protected volatile long lastFailure;
    protected volatile long totalTime;
    protected LinkedBlockingQueue<LoginEvent> queue = new LinkedBlockingQueue();
    public static final int TRANSACTION_SIZE = 20;

    public DefaultBruteForceProtector(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public void failure(KeycloakSession session, LoginEvent event) {
        logger.debug("failure");
        RealmModel realm = this.getRealmModel(session, event);
        this.logFailure(event);
        UserModel user = session.users().getUserById(event.userId, realm);
        UserLoginFailureModel userLoginFailure = this.getUserModel(session, event);
        if (user != null) {
            if (userLoginFailure == null) {
                userLoginFailure = session.sessions().addUserLoginFailure(realm, event.userId);
            }
            userLoginFailure.setLastIPFailure(event.ip);
            long currentTime = System.currentTimeMillis();
            long last = userLoginFailure.getLastFailure();
            long deltaTime = 0L;
            if (last > 0L) {
                deltaTime = currentTime - last;
            }
            userLoginFailure.setLastFailure(currentTime);
            if (deltaTime > 0L && deltaTime > (long)realm.getMaxDeltaTimeSeconds() * 1000L) {
                userLoginFailure.clearFailures();
            }
            userLoginFailure.incrementFailures();
            logger.debugv("new num failures: {0}", userLoginFailure.getNumFailures());
            int waitSeconds = realm.getWaitIncrementSeconds() * (userLoginFailure.getNumFailures() / realm.getFailureFactor());
            logger.debugv("waitSeconds: {0}", waitSeconds);
            logger.debugv("deltaTime: {0}", deltaTime);
            if (waitSeconds == 0 && last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
                logger.debugv("quick login, set min wait seconds", new Object[0]);
                waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
            }
            if (waitSeconds > 0) {
                waitSeconds = Math.min(realm.getMaxFailureWaitSeconds(), waitSeconds);
                int notBefore = (int)(currentTime / 1000L) + waitSeconds;
                logger.debugv("set notBefore: {0}", notBefore);
                userLoginFailure.setFailedLoginNotBefore(notBefore);
            }
        }
    }

    protected UserLoginFailureModel getUserModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = this.getRealmModel(session, event);
        if (realm == null) {
            return null;
        }
        UserLoginFailureModel user = session.sessions().getUserLoginFailure(realm, event.userId);
        if (user == null) {
            return null;
        }
        return user;
    }

    protected RealmModel getRealmModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = session.realms().getRealm(event.realmId);
        if (realm == null) {
            return null;
        }
        return realm;
    }

    public void start() {
        new Thread((Runnable)this, "Brute Force Protector").start();
    }

    public void shutdown() {
        this.run = false;
        try {
            this.queue.offer(new ShutdownEvent());
            this.shutdownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void logFailure(LoginEvent event) {
        logger.loginFailure(event.userId, event.ip);
        ++this.failures;
        long delta = 0L;
        if (this.lastFailure > 0L) {
            delta = System.currentTimeMillis() - this.lastFailure;
            this.totalTime = delta > (long)this.maxDeltaTimeSeconds * 1000L ? 0L : (this.totalTime += delta);
        }
    }

    public void failedLogin(RealmModel realm, UserModel user, ClientConnection clientConnection) {
        try {
            FailedLogin event = new FailedLogin(realm.getId(), user.getId(), clientConnection.getRemoteAddr());
            this.queue.offer(event);
            event.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserModel user) {
        int currTime;
        UserLoginFailureModel failure = session.sessions().getUserLoginFailure(realm, user.getId());
        if (failure != null && (currTime = (int)(System.currentTimeMillis() / 1000L)) < failure.getFailedLoginNotBefore()) {
            logger.debugv("Current: {0} notBefore: {1}", currTime, failure.getFailedLoginNotBefore());
            return true;
        }
        return false;
    }

    public void close() {
    }

    protected class FailedLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public FailedLogin(String realmId, String userId, String ip) {
            super(realmId, userId, ip);
            this.latch = new CountDownLatch(1);
        }
    }

    protected class ShutdownEvent
    extends LoginEvent {
        public ShutdownEvent() {
            super(null, null, null);
        }
    }

    protected abstract class LoginEvent
    implements Comparable<LoginEvent> {
        protected final String realmId;
        protected final String userId;
        protected final String ip;

        protected LoginEvent(String realmId, String userId, String ip) {
            this.realmId = realmId;
            this.userId = userId;
            this.ip = ip;
        }

        @Override
        public int compareTo(LoginEvent o) {
            return this.userId.compareTo(o.userId);
        }
    }
}

