/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.PolicyEvaluationRequest;
import org.keycloak.authorization.admin.representation.PolicyEvaluationResponse;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;

public class PolicyEvaluationService {
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest httpRequest;
    private final ResourceServer resourceServer;

    PolicyEvaluationService(ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void evaluate(PolicyEvaluationRequest evaluationRequest, @Suspended AsyncResponse asyncResponse) {
        KeycloakIdentity identity = this.createIdentity(evaluationRequest);
        EvaluationContext evaluationContext = this.createEvaluationContext(evaluationRequest, identity);
        this.authorization.evaluators().from(this.createPermissions(evaluationRequest, evaluationContext, this.authorization), evaluationContext).evaluate((Decision)this.createDecisionCollector(evaluationRequest, this.authorization, identity, asyncResponse));
    }

    private DecisionResultCollector createDecisionCollector(final PolicyEvaluationRequest evaluationRequest, final AuthorizationProvider authorization, final KeycloakIdentity identity, final AsyncResponse asyncResponse) {
        return new DecisionResultCollector(){

            protected void onComplete(List<Result> results) {
                try {
                    asyncResponse.resume((Object)Response.ok((Object)PolicyEvaluationResponse.build(evaluationRequest, results, PolicyEvaluationService.this.resourceServer, authorization, identity)).build());
                }
                catch (Throwable cause) {
                    asyncResponse.resume(cause);
                }
            }

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }
        };
    }

    private EvaluationContext createEvaluationContext(final PolicyEvaluationRequest representation, KeycloakIdentity identity) {
        return new KeycloakEvaluationContext(identity, this.authorization.getKeycloakSession()){

            @Override
            public Attributes getAttributes() {
                HashMap attributes = new HashMap(super.getAttributes().toMap());
                Map<String, String> givenAttributes = representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, entryValue) -> {
                        if (entryValue != null) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (String value : entryValue.split(",")) {
                                values.add(value);
                            }
                            attributes.put(key, values);
                        }
                    });
                }
                return Attributes.from(attributes);
            }
        };
    }

    private List<ResourcePermission> createPermissions(PolicyEvaluationRequest representation, EvaluationContext evaluationContext, AuthorizationProvider authorization) {
        List<PolicyEvaluationRequest.Resource> resources = representation.getResources();
        return resources.stream().flatMap(resource -> {
            Set<String> givenScopes = resource.getScopes();
            if (givenScopes == null) {
                givenScopes = new HashSet<String>();
            }
            StoreFactory storeFactory = authorization.getStoreFactory();
            if (resource.getId() != null) {
                Resource resourceModel = storeFactory.getResourceStore().findById(resource.getId());
                return Permissions.createResourcePermissions(resourceModel, givenScopes, authorization).stream();
            }
            if (resource.getType() != null) {
                Set<String> finalGivenScopes = givenScopes;
                return storeFactory.getResourceStore().findByType(resource.getType()).stream().flatMap(resource1 -> Permissions.createResourcePermissions(resource1, finalGivenScopes, authorization).stream());
            }
            ScopeStore scopeStore = storeFactory.getScopeStore();
            List scopes = givenScopes.stream().map(scopeName -> scopeStore.findByName(scopeName, this.resourceServer.getId())).collect(Collectors.toList());
            List collect = scopes.stream().map(scope -> new ResourcePermission(null, Arrays.asList(scope), this.resourceServer)).collect(Collectors.toList());
            if (scopes.isEmpty()) {
                scopes = scopeStore.findByResourceServer(this.resourceServer.getId());
            }
            for (Scope scope2 : scopes) {
                collect.addAll(storeFactory.getResourceStore().findByScope(new String[]{scope2.getId()}).stream().map(resource12 -> new ResourcePermission(resource12, Arrays.asList(scope2), this.resourceServer)).collect(Collectors.toList()));
            }
            return collect.stream();
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeycloakIdentity createIdentity(PolicyEvaluationRequest representation) {
        AccessToken.Access realmAccess;
        AccessToken accessToken;
        KeycloakSession keycloakSession;
        block10: {
            UserSessionModel userSession;
            ClientModel clientModel;
            UserModel userModel;
            RealmModel realm;
            block9: {
                String subject;
                keycloakSession = this.authorization.getKeycloakSession();
                realm = keycloakSession.getContext().getRealm();
                accessToken = new AccessToken();
                accessToken.subject(representation.getUserId());
                accessToken.issuedFor(representation.getClientId());
                accessToken.audience(new String[]{representation.getClientId()});
                accessToken.issuer(Urls.realmIssuer(keycloakSession.getContext().getUri().getBaseUri(), realm.getName()));
                accessToken.setRealmAccess(new AccessToken.Access());
                realmAccess = accessToken.getRealmAccess();
                Map claims = accessToken.getOtherClaims();
                Map<String, String> givenAttributes = representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, value) -> claims.put(key, Arrays.asList(value)));
                }
                if ((subject = accessToken.getSubject()) == null || (userModel = keycloakSession.users().getUserById(subject, realm)) == null) break block10;
                userModel.getAttributes().forEach(claims::put);
                userModel.getRoleMappings().stream().map(RoleModel::getName).forEach(roleName -> realmAccess.addRole(roleName));
                String clientId = representation.getClientId();
                if (clientId == null) {
                    clientId = this.resourceServer.getClientId();
                }
                if (clientId == null) break block10;
                clientModel = realm.getClientById(clientId);
                ClientSessionModel clientSession = null;
                userSession = null;
                try {
                    clientSession = keycloakSession.sessions().createClientSession(realm, clientModel);
                    UserSessionModel finalUserSession = userSession = keycloakSession.sessions().createUserSession(realm, userModel, userModel.getUsername(), "127.0.0.1", "passwd", false, null, null);
                    ClientSessionModel finalClientSession = clientSession;
                    for (ProtocolMapperModel mapping : clientModel.getProtocolMappers()) {
                        KeycloakSessionFactory sessionFactory = keycloakSession.getKeycloakSessionFactory();
                        ProtocolMapper mapper = (ProtocolMapper)sessionFactory.getProviderFactory(ProtocolMapper.class, mapping.getProtocolMapper());
                        if (mapper == null || !(mapper instanceof OIDCAccessTokenMapper)) continue;
                        accessToken = ((OIDCAccessTokenMapper)mapper).transformAccessToken(accessToken, mapping, keycloakSession, finalUserSession, finalClientSession);
                    }
                    if (clientSession == null) break block9;
                }
                catch (Throwable throwable) {
                    if (clientSession != null) {
                        keycloakSession.sessions().removeClientSession(realm, clientSession);
                    }
                    if (userSession != null) {
                        keycloakSession.sessions().removeUserSession(realm, userSession);
                    }
                    throw throwable;
                }
                keycloakSession.sessions().removeClientSession(realm, clientSession);
            }
            if (userSession != null) {
                keycloakSession.sessions().removeUserSession(realm, userSession);
            }
            AccessToken.Access clientAccess = accessToken.addAccess(clientModel.getClientId());
            clientAccess.roles(new HashSet());
            userModel.getClientRoleMappings(clientModel).stream().map(RoleModel::getName).forEach(roleName -> clientAccess.addRole(roleName));
            ClientModel resourceServerClient = realm.getClientById(this.resourceServer.getClientId());
            AccessToken.Access resourceServerAccess = accessToken.addAccess(resourceServerClient.getClientId());
            resourceServerAccess.roles(new HashSet());
            userModel.getClientRoleMappings(resourceServerClient).stream().map(RoleModel::getName).forEach(roleName -> resourceServerAccess.addRole(roleName));
        }
        if (representation.getRoleIds() != null) {
            representation.getRoleIds().forEach(roleName -> realmAccess.addRole(roleName));
        }
        return new KeycloakIdentity(accessToken, keycloakSession);
    }
}

