/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.security.PublicKey;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;

public class ClientRegistrationTokenUtils {
    public static final String TYPE_INITIAL_ACCESS_TOKEN = "InitialAccessToken";
    public static final String TYPE_REGISTRATION_ACCESS_TOKEN = "RegistrationAccessToken";

    public static String updateRegistrationAccessToken(KeycloakSession session, ClientModel client) {
        return ClientRegistrationTokenUtils.updateRegistrationAccessToken(session.getContext().getRealm(), session.getContext().getUri(), client);
    }

    public static String updateRegistrationAccessToken(RealmModel realm, UriInfo uri, ClientModel client) {
        String id = KeycloakModelUtils.generateId();
        client.setRegistrationToken(id);
        String token = ClientRegistrationTokenUtils.createToken(realm, uri, id, TYPE_REGISTRATION_ACCESS_TOKEN, 0);
        return token;
    }

    public static String createInitialAccessToken(RealmModel realm, UriInfo uri, ClientInitialAccessModel model) {
        return ClientRegistrationTokenUtils.createToken(realm, uri, model.getId(), TYPE_INITIAL_ACCESS_TOKEN, model.getExpiration() > 0 ? model.getTimestamp() + model.getExpiration() : 0);
    }

    public static TokenVerification verifyToken(RealmModel realm, UriInfo uri, String token) {
        JsonWebToken jwt;
        JWSInput input;
        if (token == null) {
            return TokenVerification.error(new RuntimeException("Missing token"));
        }
        try {
            input = new JWSInput(token);
        }
        catch (JWSInputException e) {
            return TokenVerification.error(new RuntimeException("Invalid token", e));
        }
        if (!RSAProvider.verify((JWSInput)input, (PublicKey)realm.getPublicKey())) {
            return TokenVerification.error(new RuntimeException("Failed verify token"));
        }
        try {
            jwt = (JsonWebToken)input.readJsonContent(JsonWebToken.class);
        }
        catch (JWSInputException e) {
            return TokenVerification.error(new RuntimeException("Token is not JWT", e));
        }
        if (!ClientRegistrationTokenUtils.getIssuer(realm, uri).equals(jwt.getIssuer())) {
            return TokenVerification.error(new RuntimeException("Issuer from token don't match with the realm issuer."));
        }
        if (!jwt.isActive()) {
            return TokenVerification.error(new RuntimeException("Token not active."));
        }
        if (!("Bearer".equals(jwt.getType()) || TYPE_INITIAL_ACCESS_TOKEN.equals(jwt.getType()) || TYPE_REGISTRATION_ACCESS_TOKEN.equals(jwt.getType()))) {
            return TokenVerification.error(new RuntimeException("Invalid type of token"));
        }
        return TokenVerification.success(jwt);
    }

    private static String createToken(RealmModel realm, UriInfo uri, String id, String type, int expiration) {
        JsonWebToken jwt = new JsonWebToken();
        String issuer = ClientRegistrationTokenUtils.getIssuer(realm, uri);
        jwt.type(type);
        jwt.id(id);
        jwt.issuedAt(Time.currentTime());
        jwt.expiration(expiration);
        jwt.issuer(issuer);
        jwt.audience(new String[]{issuer});
        String token = new JWSBuilder().jsonContent((Object)jwt).rsa256(realm.getPrivateKey());
        return token;
    }

    private static String getIssuer(RealmModel realm, UriInfo uri) {
        return Urls.realmIssuer(uri.getBaseUri(), realm.getName());
    }

    protected static class TokenVerification {
        private final JsonWebToken jwt;
        private final RuntimeException error;

        public static TokenVerification success(JsonWebToken jwt) {
            return new TokenVerification(jwt, null);
        }

        public static TokenVerification error(RuntimeException error) {
            return new TokenVerification(null, error);
        }

        private TokenVerification(JsonWebToken jwt, RuntimeException error) {
            this.jwt = jwt;
            this.error = error;
        }

        public JsonWebToken getJwt() {
            return this.jwt;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

