/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import java.io.IOException;
import java.net.URI;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.JWKSUtils;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.util.CertificateInfoHelper;

public class DescriptionConverter {
    public static ClientRepresentation toInternal(KeycloakSession session, OIDCClientRepresentation clientOIDC) throws ClientRegistrationException {
        Algorithm algorithm;
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientOIDC.getClientId());
        client.setName(clientOIDC.getClientName());
        client.setRedirectUris(clientOIDC.getRedirectUris());
        client.setBaseUrl(clientOIDC.getClientUri());
        List<String> oidcResponseTypes = clientOIDC.getResponseTypes();
        if (oidcResponseTypes == null || oidcResponseTypes.isEmpty()) {
            oidcResponseTypes = Collections.singletonList("code");
        }
        List oidcGrantTypes = clientOIDC.getGrantTypes();
        try {
            OIDCResponseType responseType = OIDCResponseType.parse(oidcResponseTypes);
            client.setStandardFlowEnabled(Boolean.valueOf(responseType.hasResponseType("code")));
            client.setImplicitFlowEnabled(Boolean.valueOf(responseType.isImplicitOrHybridFlow()));
            if (oidcGrantTypes != null) {
                client.setDirectAccessGrantsEnabled(Boolean.valueOf(oidcGrantTypes.contains("password")));
                client.setServiceAccountsEnabled(Boolean.valueOf(oidcGrantTypes.contains("client_credentials")));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ClientRegistrationException(iae.getMessage(), iae);
        }
        String authMethod = clientOIDC.getTokenEndpointAuthMethod();
        ClientAuthenticatorFactory clientAuthFactory = authMethod == null ? (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, KeycloakModelUtils.getDefaultClientAuthenticatorType()) : AuthorizeClientUtil.findClientAuthenticatorForOIDCAuthMethod(session, authMethod);
        if (clientAuthFactory == null) {
            throw new ClientRegistrationException("Not found clientAuthenticator for requested token_endpoint_auth_method");
        }
        client.setClientAuthenticatorType(clientAuthFactory.getId());
        PublicKey publicKey = DescriptionConverter.retrievePublicKey(session, clientOIDC);
        if (authMethod != null && authMethod.equals("private_key_jwt") && publicKey == null) {
            throw new ClientRegistrationException("Didn't find key of supported keyType for use " + JWK.Use.SIG.asString());
        }
        if (publicKey != null) {
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            CertificateRepresentation rep = new CertificateRepresentation();
            rep.setPublicKey(publicKeyPem);
            CertificateInfoHelper.updateClientRepresentationCertificateInfo(client, rep, "jwt.credential");
        }
        OIDCAdvancedConfigWrapper configWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
        if (clientOIDC.getUserinfoSignedResponseAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getUserinfoSignedResponseAlg());
            configWrapper.setUserInfoSignedResponseAlg(algorithm);
        }
        if (clientOIDC.getRequestObjectSigningAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getRequestObjectSigningAlg());
            configWrapper.setRequestObjectSignatureAlg(algorithm);
        }
        return client;
    }

    private static PublicKey retrievePublicKey(KeycloakSession session, OIDCClientRepresentation clientOIDC) {
        JSONWebKeySet keySet;
        if (clientOIDC.getJwksUri() == null && clientOIDC.getJwks() == null) {
            return null;
        }
        if (clientOIDC.getJwksUri() != null && clientOIDC.getJwks() != null) {
            throw new ClientRegistrationException("Illegal to use both jwks_uri and jwks");
        }
        if (clientOIDC.getJwks() != null) {
            keySet = clientOIDC.getJwks();
        } else {
            try {
                keySet = JWKSUtils.sendJwksRequest(session, clientOIDC.getJwksUri());
            }
            catch (IOException ioe) {
                throw new ClientRegistrationException("Failed to send JWKS request to specified jwks_uri", ioe);
            }
        }
        return JWKSUtils.getKeyForUse(keySet, JWK.Use.SIG);
    }

    public static OIDCClientRepresentation toExternalResponse(KeycloakSession session, ClientRepresentation client, URI uri) {
        OIDCClientRepresentation response = new OIDCClientRepresentation();
        response.setClientId(client.getClientId());
        ClientAuthenticatorFactory clientAuth = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, client.getClientAuthenticatorType());
        Set oidcClientAuthMethods = clientAuth.getProtocolAuthenticatorMethods("openid-connect");
        if (oidcClientAuthMethods != null && !oidcClientAuthMethods.isEmpty()) {
            response.setTokenEndpointAuthMethod((String)oidcClientAuthMethods.iterator().next());
        }
        if (client.getClientAuthenticatorType().equals("client-secret")) {
            response.setClientSecret(client.getSecret());
            response.setClientSecretExpiresAt(Integer.valueOf(0));
        }
        response.setClientName(client.getName());
        response.setClientUri(client.getBaseUrl());
        response.setRedirectUris(client.getRedirectUris());
        response.setRegistrationAccessToken(client.getRegistrationAccessToken());
        response.setRegistrationClientUri(uri.toString());
        response.setResponseTypes(DescriptionConverter.getOIDCResponseTypes(client));
        response.setGrantTypes(DescriptionConverter.getOIDCGrantTypes(client));
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
        if (config.isUserInfoSignatureRequired()) {
            response.setUserinfoSignedResponseAlg(config.getUserInfoSignedResponseAlg().toString());
        }
        if (config.getRequestObjectSignatureAlg() != null) {
            response.setRequestObjectSigningAlg(config.getRequestObjectSignatureAlg().toString());
        }
        return response;
    }

    private static List<String> getOIDCResponseTypes(ClientRepresentation client) {
        ArrayList<String> responseTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            responseTypes.add("code");
            responseTypes.add("none");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("id_token");
            responseTypes.add("id_token token");
        }
        if (client.isStandardFlowEnabled().booleanValue() && client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("code id_token");
            responseTypes.add("code token");
            responseTypes.add("code id_token token");
        }
        return responseTypes;
    }

    private static List<String> getOIDCGrantTypes(ClientRepresentation client) {
        ArrayList<String> grantTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            grantTypes.add("authorization_code");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            grantTypes.add("implicit");
        }
        if (client.isDirectAccessGrantsEnabled().booleanValue()) {
            grantTypes.add("password");
        }
        if (client.isServiceAccountsEnabled().booleanValue()) {
            grantTypes.add("client_credentials");
        }
        grantTypes.add("refresh_token");
        return grantTypes;
    }
}

