/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;

public class ComponentResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public ComponentResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ComponentRepresentation> getComponents(@QueryParam(value="parent") String parent, @QueryParam(value="type") String type) {
        this.auth.requireManage();
        List components = Collections.EMPTY_LIST;
        components = parent == null ? this.realm.getComponents() : (type == null ? this.realm.getComponents(parent) : this.realm.getComponents(parent, type));
        LinkedList<ComponentRepresentation> reps = new LinkedList<ComponentRepresentation>();
        for (ComponentModel component : components) {
            ComponentRepresentation rep = ModelToRepresentation.toRepresentation((ComponentModel)component);
            reps.add(rep);
        }
        return reps;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(ComponentRepresentation rep) {
        this.auth.requireManage();
        ComponentModel model = RepresentationToModel.toModel((ComponentRepresentation)rep);
        if (model.getParentId() == null) {
            model.setParentId(this.realm.getId());
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, model.getId()).representation(rep).success();
        model = this.realm.addComponentModel(model);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @Path(value="{id}")
    public ComponentRepresentation getComponent(@PathParam(value="id") String id) {
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        return ModelToRepresentation.toRepresentation((ComponentModel)model);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void updateComponent(@PathParam(value="id") String id, ComponentRepresentation rep) {
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        model = RepresentationToModel.toModel((ComponentRepresentation)rep);
        model.setId(id);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo, model.getId()).representation(rep).success();
        this.realm.updateComponent(model);
    }

    @DELETE
    @Path(value="{id}")
    public void removeComponent(@PathParam(value="id") String id) {
        this.auth.requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo, model.getId()).success();
        this.realm.removeComponent(model);
    }
}

