/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAuth;

public class ProtocolMappersResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    protected ProtocolMapperContainerModel client;
    protected RealmAuth auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public ProtocolMappersResource(RealmModel realm, ProtocolMapperContainerModel client, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = client;
        this.adminEvent = adminEvent.resource(ResourceType.PROTOCOL_MAPPER);
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @NoCache
    @Path(value="protocol/{protocol}")
    @Produces(value={"application/json"})
    public List<ProtocolMapperRepresentation> getMappersPerProtocol(@PathParam(value="protocol") String protocol) {
        this.auth.requireAny();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        for (ProtocolMapperModel mapper : this.client.getProtocolMappers()) {
            if (!mapper.getProtocol().equals(protocol)) continue;
            mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
        }
        return mappers;
    }

    @Path(value="models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response createMapper(ProtocolMapperRepresentation rep) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ProtocolMapperModel model = null;
        try {
            model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
            this.validateModel(model);
            model = this.client.addProtocolMapper(model);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, model.getId()).representation(rep).success();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Protocol mapper exists with same name");
        }
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @Path(value="add-models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public void createMapper(List<ProtocolMapperRepresentation> reps) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ProtocolMapperModel model = null;
        for (ProtocolMapperRepresentation rep : reps) {
            model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
            this.validateModel(model);
            model = this.client.addProtocolMapper(model);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(reps).success();
    }

    @GET
    @NoCache
    @Path(value="models")
    @Produces(value={"application/json"})
    public List<ProtocolMapperRepresentation> getMappers() {
        this.auth.requireAny();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
        for (ProtocolMapperModel mapper : this.client.getProtocolMappers()) {
            mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
        }
        return mappers;
    }

    @GET
    @NoCache
    @Path(value="models/{id}")
    @Produces(value={"application/json"})
    public ProtocolMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.requireAny();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="models/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, ProtocolMapperRepresentation rep) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
        this.validateModel(model);
        this.client.updateProtocolMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="models/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.client.removeProtocolMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    private void validateModel(ProtocolMapperModel model) {
        try {
            ProtocolMapper mapper = (ProtocolMapper)this.session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, model.getProtocolMapper());
            if (mapper != null) {
                mapper.validateConfig(this.session, this.realm, this.client, model);
            }
        }
        catch (ProtocolMapperConfigException ex) {
            logger.error(ex.getMessage());
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.getAuth().getToken().getLocale());
            throw new ErrorResponseException(ex.getMessage(), MessageFormat.format(messages.getProperty(ex.getMessage(), ex.getMessage()), ex.getParameters()), Response.Status.BAD_REQUEST);
        }
    }
}

