/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.services.validation.ValidationMessage;

public class ValidationMessages {
    private Set<ValidationMessage> messages = new LinkedHashSet<ValidationMessage>();

    public ValidationMessages() {
    }

    public ValidationMessages(String ... messages) {
        for (String message : messages) {
            this.add(message);
        }
    }

    public void add(String message) {
        this.messages.add(new ValidationMessage(message));
    }

    public void add(String message, String localizedMessageKey) {
        this.messages.add(new ValidationMessage(message, localizedMessageKey, new Object[0]));
    }

    public void add(String fieldId, String message, String localizedMessageKey) {
        ValidationMessage validationMessage = new ValidationMessage(message, localizedMessageKey, new Object[0]);
        validationMessage.setFieldId(fieldId);
        this.add(validationMessage);
    }

    public void add(ValidationMessage message) {
        this.messages.add(message);
    }

    public boolean fieldHasError(String fieldId) {
        for (ValidationMessage message : this.messages) {
            if (!message.getFieldId().equals(fieldId)) continue;
            return true;
        }
        return false;
    }

    public Set<ValidationMessage> getMessages() {
        return Collections.unmodifiableSet(this.messages);
    }

    protected String getStringMessages(Function<? super ValidationMessage, ? extends String> function) {
        return this.messages.stream().map(function).collect(Collectors.joining("; "));
    }

    public String getStringMessages() {
        return this.getStringMessages(ValidationMessage::getMessage);
    }

    public String getStringMessages(Properties localizedMessages) {
        return this.getStringMessages((? super ValidationMessage x) -> x.getMessage(localizedMessages));
    }
}

