/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.RSATokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;

public class UserInfoEndpoint {
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse response;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final AppAuthManager appAuthManager;
    private final RealmModel realm;

    public UserInfoEndpoint(TokenManager tokenManager, RealmModel realm) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.appAuthManager = new AppAuthManager();
    }

    @Path(value="/")
    @OPTIONS
    public Response issueUserInfoPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @NoCache
    public Response issueUserInfoGet(@Context HttpHeaders headers) {
        String accessToken = this.appAuthManager.extractAuthorizationHeaderToken(headers);
        return this.issueUserInfo(accessToken);
    }

    @Path(value="/")
    @POST
    @NoCache
    public Response issueUserInfoPost() {
        HttpHeaders headers = this.request.getHttpHeaders();
        String accessToken = this.appAuthManager.extractAuthorizationHeaderToken(headers);
        if (accessToken == null) {
            accessToken = (String)this.request.getDecodedFormParameters().getFirst((Object)"access_token");
        }
        return this.issueUserInfo(accessToken);
    }

    private Response issueUserInfo(String tokenString) {
        Response.ResponseBuilder responseBuilder;
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection).event(EventType.USER_INFO_REQUEST).detail("auth_method", "validate_access_token");
        if (tokenString == null) {
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", "Token not provided", Response.Status.BAD_REQUEST);
        }
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.realm.getPublicKey(), (String)Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()), (boolean)true, (boolean)true);
        }
        catch (VerificationException e) {
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "Token invalid: " + e.getMessage(), Response.Status.UNAUTHORIZED);
        }
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, token.getSessionState());
        ClientSessionModel clientSession = this.session.sessions().getClientSession(token.getClientSession());
        if (userSession == null) {
            event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_request", "User session not found", Response.Status.BAD_REQUEST);
        }
        event.session(userSession);
        UserModel userModel = userSession.getUser();
        if (userModel == null) {
            event.error("user_not_found");
            throw new ErrorResponseException("invalid_request", "User not found", Response.Status.BAD_REQUEST);
        }
        event.user(userModel).detail("username", userModel.getUsername());
        if (clientSession == null || !AuthenticationManager.isSessionValid(this.realm, userSession)) {
            event.error("session_expired");
            throw new ErrorResponseException("invalid_token", "Session expired", Response.Status.UNAUTHORIZED);
        }
        ClientModel clientModel = this.realm.getClientByClientId(token.getIssuedFor());
        if (clientModel == null) {
            event.error("client_not_found");
            throw new ErrorResponseException("invalid_request", "Client not found", Response.Status.BAD_REQUEST);
        }
        event.client(clientModel);
        if (!clientModel.isEnabled()) {
            event.error("client_disabled");
            throw new ErrorResponseException("invalid_request", "Client disabled", Response.Status.BAD_REQUEST);
        }
        AccessToken userInfo = new AccessToken();
        this.tokenManager.transformUserInfoAccessToken(this.session, userInfo, this.realm, clientModel, userModel, userSession, clientSession);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.putAll(userInfo.getOtherClaims());
        claims.put("sub", userModel.getId());
        OIDCAdvancedConfigWrapper cfg = OIDCAdvancedConfigWrapper.fromClientModel(clientModel);
        if (cfg.isUserInfoSignatureRequired()) {
            String issuerUrl = Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName());
            String audience = clientModel.getClientId();
            claims.put("iss", issuerUrl);
            claims.put("aud", audience);
            Algorithm signatureAlg = cfg.getUserInfoSignedResponseAlg();
            PrivateKey privateKey = this.realm.getPrivateKey();
            String signedUserInfo = new JWSBuilder().jsonContent(claims).sign(signatureAlg, privateKey);
            responseBuilder = Response.ok((Object)signedUserInfo).header("Content-Type", (Object)"application/jwt");
            event.detail("signature_required", "true");
            event.detail("signature_algorithm", cfg.getUserInfoSignedResponseAlg().toString());
        } else {
            responseBuilder = Response.ok(claims).header("Content-Type", (Object)"application/json");
            event.detail("signature_required", "false");
        }
        event.success();
        return Cors.add(this.request, responseBuilder).auth().allowedOrigins(token).build();
    }
}

