/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.config;

import java.net.URI;
import java.security.Key;
import javax.ws.rs.core.UriInfo;
import org.keycloak.authorization.config.Configuration;
import org.keycloak.common.util.PemUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.wellknown.WellKnownProvider;

public class UmaWellKnownProvider
implements WellKnownProvider {
    private final KeycloakSession session;

    public UmaWellKnownProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public Object getConfig() {
        RealmModel realm = this.session.getContext().getRealm();
        UriInfo uriInfo = this.session.getContext().getUri();
        return Configuration.fromDefault(RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString(), realm.getName(), URI.create(RealmsResource.protocolUrl(uriInfo).path(OIDCLoginProtocolService.class, "auth").build(new Object[]{realm.getName(), "openid-connect"}).toString()), URI.create(RealmsResource.protocolUrl(uriInfo).path(OIDCLoginProtocolService.class, "token").build(new Object[]{realm.getName(), "openid-connect"}).toString()), PemUtils.encodeKey((Key)this.session.keys().getActiveKey(realm).getPublicKey()));
    }

    public void close() {
    }
}

