/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;

public class OTPCredentialProvider
implements CredentialProvider,
CredentialInputValidator,
CredentialInputUpdater,
OnUserCache {
    private static final Logger logger = Logger.getLogger(OTPCredentialProvider.class);
    protected KeycloakSession session;

    protected List<CredentialModel> getCachedCredentials(UserModel user, String type) {
        if (!(user instanceof CachedUserModel)) {
            return Collections.EMPTY_LIST;
        }
        CachedUserModel cached = (CachedUserModel)user;
        List rtn = (List)cached.getCachedWith().get(OTPCredentialProvider.class.getName() + "." + type);
        if (rtn == null) {
            return Collections.EMPTY_LIST;
        }
        return rtn;
    }

    protected UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List creds = this.getCredentialStore().getStoredCredentialsByType(realm, (UserModel)user, "totp");
        user.getCachedWith().put(OTPCredentialProvider.class.getName() + "." + "totp", creds);
    }

    public OTPCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType())) {
            return false;
        }
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        UserCredentialModel inputModel = (UserCredentialModel)input;
        CredentialModel model = null;
        if (inputModel.getDevice() != null && (model = this.getCredentialStore().getStoredCredentialByNameAndType(realm, user, inputModel.getDevice(), "totp")) == null) {
            model = this.getCredentialStore().getStoredCredentialByNameAndType(realm, user, inputModel.getDevice(), "hotp");
        }
        if (model == null) {
            this.disableCredentialType(realm, user, "otp");
            model = new CredentialModel();
        }
        OTPPolicy policy = realm.getOTPPolicy();
        model.setDigits(policy.getDigits());
        model.setCounter(policy.getInitialCounter());
        model.setAlgorithm(policy.getAlgorithm());
        model.setType(input.getType());
        model.setValue(inputModel.getValue());
        model.setDevice(inputModel.getDevice());
        model.setPeriod(policy.getPeriod());
        model.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        if (model.getId() == null) {
            this.getCredentialStore().createCredential(realm, user, model);
        } else {
            this.getCredentialStore().updateCredential(realm, user, model);
        }
        this.session.getUserCache().evict(realm, user);
        return true;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        List totp;
        boolean disableTOTP = false;
        boolean disableHOTP = false;
        if ("otp".equals(credentialType)) {
            disableTOTP = true;
            disableHOTP = true;
        } else if ("hotp".equals(credentialType)) {
            disableHOTP = true;
        } else if ("totp".equals(credentialType)) {
            disableTOTP = true;
        }
        if (disableHOTP) {
            List hotp = this.getCredentialStore().getStoredCredentialsByType(realm, user, "hotp");
            for (CredentialModel cred : hotp) {
                this.getCredentialStore().removeStoredCredential(realm, user, cred.getId());
            }
        }
        if (disableTOTP && !(totp = this.getCredentialStore().getStoredCredentialsByType(realm, user, "totp")).isEmpty()) {
            for (CredentialModel cred : totp) {
                this.getCredentialStore().removeStoredCredential(realm, user, cred.getId());
            }
        }
        if (disableTOTP || disableHOTP) {
            this.session.getUserCache().evict(realm, user);
        }
    }

    public boolean supportsCredentialType(String credentialType) {
        return "otp".equals(credentialType) || "hotp".equals(credentialType) || "totp".equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        if ("otp".equals(credentialType)) {
            if (realm.getOTPPolicy().getType().equals("hotp")) {
                return this.configuredForHOTP(realm, user);
            }
            return this.configuredForTOTP(realm, user);
        }
        if ("hotp".equals(credentialType)) {
            return this.configuredForHOTP(realm, user);
        }
        if ("totp".equals(credentialType)) {
            return this.configuredForTOTP(realm, user);
        }
        return false;
    }

    protected boolean configuredForHOTP(RealmModel realm, UserModel user) {
        return !this.getCredentialStore().getStoredCredentialsByType(realm, user, "hotp").isEmpty();
    }

    protected boolean configuredForTOTP(RealmModel realm, UserModel user) {
        return !this.getCachedCredentials(user, "totp").isEmpty() || !this.getCredentialStore().getStoredCredentialsByType(realm, user, "totp").isEmpty();
    }

    public static boolean validOTP(RealmModel realm, String token, String secret) {
        OTPPolicy policy = realm.getOTPPolicy();
        if (policy.getType().equals("totp")) {
            TimeBasedOTP validator = new TimeBasedOTP(policy.getAlgorithm(), policy.getDigits(), policy.getPeriod(), policy.getLookAheadWindow());
            return validator.validateTOTP(token, secret.getBytes());
        }
        HmacOTP validator = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
        int c = validator.validateHOTP(token, secret, policy.getInitialCounter());
        return c > -1;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        String token = ((UserCredentialModel)input).getValue();
        if (token == null) {
            return false;
        }
        OTPPolicy policy = realm.getOTPPolicy();
        if (realm.getOTPPolicy().getType().equals("hotp")) {
            HmacOTP validator = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
            for (CredentialModel cred : this.getCredentialStore().getStoredCredentialsByType(realm, user, "hotp")) {
                int counter = validator.validateHOTP(token, cred.getValue(), cred.getCounter());
                if (counter < 0) continue;
                cred.setCounter(counter);
                this.getCredentialStore().updateCredential(realm, user, cred);
                return true;
            }
        } else {
            TimeBasedOTP validator = new TimeBasedOTP(policy.getAlgorithm(), policy.getDigits(), policy.getPeriod(), policy.getLookAheadWindow());
            List creds = this.getCachedCredentials(user, "totp");
            if (creds.isEmpty()) {
                creds = this.getCredentialStore().getStoredCredentialsByType(realm, user, "totp");
            } else {
                logger.debugv("Cache hit for TOTP for user {0}", (Object)user.getUsername());
            }
            for (CredentialModel cred : creds) {
                if (!validator.validateTOTP(token, cred.getValue().getBytes())) continue;
                return true;
            }
        }
        return false;
    }
}

