/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.AbstractRsaKeyProviderFactory;
import org.keycloak.keys.JavaKeystoreKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class JavaKeystoreKeyProviderFactory
extends AbstractRsaKeyProviderFactory {
    public static final String ID = "java-keystore";
    public static String KEYSTORE_KEY = "keystore";
    public static ProviderConfigProperty KEYSTORE_PROPERTY = new ProviderConfigProperty(KEYSTORE_KEY, "Keystore", "Path to keys file", "String", null);
    public static String KEYSTORE_PASSWORD_KEY = "keystorePassword";
    public static ProviderConfigProperty KEYSTORE_PASSWORD_PROPERTY = new ProviderConfigProperty(KEYSTORE_PASSWORD_KEY, "Keystore Password", "Password for the keys", "String", null, true);
    public static String KEY_ALIAS_KEY = "keyAlias";
    public static ProviderConfigProperty KEY_ALIAS_PROPERTY = new ProviderConfigProperty(KEY_ALIAS_KEY, "Key Alias", "Alias for the private key", "String", null);
    public static String KEY_PASSWORD_KEY = "keyPassword";
    public static ProviderConfigProperty KEY_PASSWORD_PROPERTY = new ProviderConfigProperty(KEY_PASSWORD_KEY, "Key Password", "Password for the private key", "String", null, true);
    private static final String HELP_TEXT = "Loads keys from a Java keys file";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractRsaKeyProviderFactory.configurationBuilder().property(KEYSTORE_PROPERTY).property(KEYSTORE_PASSWORD_PROPERTY).property(KEY_ALIAS_PROPERTY).property(KEY_PASSWORD_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new JavaKeystoreKeyProvider(session.getContext().getRealm(), model);
    }

    @Override
    public void validateConfiguration(KeycloakSession session, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkSingle(KEYSTORE_PROPERTY, true).checkSingle(KEYSTORE_PASSWORD_PROPERTY, true).checkSingle(KEY_ALIAS_PROPERTY, true).checkSingle(KEY_PASSWORD_PROPERTY, true);
        try {
            new JavaKeystoreKeyProvider(session.getContext().getRealm(), model).loadKeys(session.getContext().getRealm(), model);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to load keys", t);
        }
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

