/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.AbstractRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.RsaKeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class RsaKeyProviderFactory
extends AbstractRsaKeyProviderFactory {
    public static final String ID = "rsa";
    private static final String HELP_TEXT = "RSA key provider that can optionally generated a self-signed certificate";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractRsaKeyProviderFactory.configurationBuilder().property(Attributes.PRIVATE_KEY_PROPERTY).property(Attributes.CERTIFICATE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new RsaKeyProvider(session.getContext().getRealm(), model);
    }

    @Override
    public void validateConfiguration(KeycloakSession session, ComponentModel model) throws ComponentValidationException {
        KeyPair keyPair;
        super.validateConfiguration(session, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkSingle(Attributes.PRIVATE_KEY_PROPERTY, true).checkSingle(Attributes.CERTIFICATE_PROPERTY, false);
        try {
            PrivateKey privateKey = PemUtils.decodePrivateKey((String)model.get("privateKey"));
            PublicKey publicKey = KeyUtils.extractPublicKey((PrivateKey)privateKey);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to decode private key", t);
        }
        if (model.contains("certificate")) {
            X509Certificate certificate = null;
            try {
                certificate = PemUtils.decodeCertificate((String)model.get("certificate"));
            }
            catch (Throwable t) {
                throw new ComponentValidationException("Failed to decode certificate", t);
            }
            if (certificate == null) {
                throw new ComponentValidationException("Failed to decode certificate", new Object[0]);
            }
            if (!certificate.getPublicKey().equals(keyPair.getPublic())) {
                throw new ComponentValidationException("Certificate does not match private key", new Object[0]);
            }
        } else {
            try {
                RealmModel realm = session.realms().getRealm(model.getParentId());
                X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
                model.put("certificate", PemUtils.encodeCertificate((Certificate)certificate));
            }
            catch (Throwable t) {
                throw new ComponentValidationException("Failed to generate self-signed certificate", new Object[0]);
            }
        }
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

