/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;

public class RequiredActionContextResult
implements RequiredActionContext {
    protected UserSessionModel userSession;
    protected ClientSessionModel clientSession;
    protected RealmModel realm;
    protected EventBuilder eventBuilder;
    protected KeycloakSession session;
    protected RequiredActionContext.Status status;
    protected Response challenge;
    protected HttpRequest httpRequest;
    protected UserModel user;
    protected RequiredActionFactory factory;

    public RequiredActionContextResult(UserSessionModel userSession, ClientSessionModel clientSession, RealmModel realm, EventBuilder eventBuilder, KeycloakSession session, HttpRequest httpRequest, UserModel user, RequiredActionFactory factory) {
        this.userSession = userSession;
        this.clientSession = clientSession;
        this.realm = realm;
        this.eventBuilder = eventBuilder;
        this.session = session;
        this.httpRequest = httpRequest;
        this.user = user;
        this.factory = factory;
    }

    public EventBuilder getEvent() {
        return this.eventBuilder;
    }

    public UserModel getUser() {
        return this.user;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public ClientConnection getConnection() {
        return this.session.getContext().getConnection();
    }

    public UriInfo getUriInfo() {
        return this.session.getContext().getUri();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public RequiredActionContext.Status getStatus() {
        return this.status;
    }

    public void challenge(Response response) {
        this.status = RequiredActionContext.Status.CHALLENGE;
        this.challenge = response;
    }

    public void failure() {
        this.status = RequiredActionContext.Status.FAILURE;
    }

    public void success() {
        this.status = RequiredActionContext.Status.SUCCESS;
    }

    public void ignore() {
        this.status = RequiredActionContext.Status.IGNORE;
    }

    public URI getActionUrl(String code) {
        return LoginActionsService.requiredActionProcessor(this.getUriInfo()).queryParam("code", new Object[]{code}).queryParam("action", new Object[]{this.factory.getId()}).build(new Object[]{this.getRealm().getName()});
    }

    public String generateCode() {
        ClientSessionCode accessCode = new ClientSessionCode(this.session, this.getRealm(), this.getClientSession());
        this.clientSession.setTimestamp(Time.currentTime());
        return accessCode.getCode();
    }

    public URI getActionUrl() {
        String accessCode = this.generateCode();
        return this.getActionUrl(accessCode);
    }

    public LoginFormsProvider form() {
        String accessCode = this.generateCode();
        URI action = this.getActionUrl(accessCode);
        LoginFormsProvider provider = ((LoginFormsProvider)this.getSession().getProvider(LoginFormsProvider.class)).setUser(this.getUser()).setActionUri(action).setClientSessionCode(accessCode);
        return provider;
    }

    public Response getChallenge() {
        return this.challenge;
    }
}

