/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.net.URI;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.Urls;

public class IdentityProviderBean {
    private boolean displaySocial;
    private List<IdentityProvider> providers;
    private RealmModel realm;
    private final KeycloakSession session;

    public IdentityProviderBean(RealmModel realm, KeycloakSession session, List<IdentityProviderModel> identityProviders, URI baseURI, UriInfo uriInfo) {
        this.realm = realm;
        this.session = session;
        if (!identityProviders.isEmpty()) {
            TreeSet<IdentityProvider> orderedSet = new TreeSet<IdentityProvider>(IdentityProviderComparator.INSTANCE);
            for (IdentityProviderModel identityProvider : identityProviders) {
                if (!identityProvider.isEnabled()) continue;
                this.addIdentityProvider(orderedSet, realm, baseURI, identityProvider);
            }
            if (!orderedSet.isEmpty()) {
                this.providers = new LinkedList<IdentityProvider>(orderedSet);
                this.displaySocial = true;
            }
        }
    }

    private void addIdentityProvider(Set<IdentityProvider> orderedSet, RealmModel realm, URI baseURI, IdentityProviderModel identityProvider) {
        String loginUrl = Urls.identityProviderAuthnRequest(baseURI, identityProvider.getAlias(), realm.getName()).toString();
        String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)identityProvider);
        orderedSet.add(new IdentityProvider(identityProvider.getAlias(), displayName, identityProvider.getProviderId(), loginUrl, identityProvider.getConfig() != null ? (String)identityProvider.getConfig().get("guiOrder") : null));
    }

    public List<IdentityProvider> getProviders() {
        return this.providers;
    }

    public boolean isDisplayInfo() {
        return this.realm.isRegistrationAllowed() || this.displaySocial;
    }

    public static class IdentityProviderComparator
    implements Comparator<IdentityProvider> {
        public static IdentityProviderComparator INSTANCE = new IdentityProviderComparator();

        private IdentityProviderComparator() {
        }

        @Override
        public int compare(IdentityProvider o1, IdentityProvider o2) {
            int o2order;
            int o1order = this.parseOrder(o1);
            if (o1order > (o2order = this.parseOrder(o2))) {
                return 1;
            }
            if (o1order < o2order) {
                return -1;
            }
            return 1;
        }

        private int parseOrder(IdentityProvider ip) {
            if (ip != null && ip.getGuiOrder() != null) {
                try {
                    return Integer.parseInt(ip.getGuiOrder());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 10000;
        }
    }

    public static class IdentityProvider {
        private final String alias;
        private final String providerId;
        private final String loginUrl;
        private final String guiOrder;
        private final String displayName;

        public IdentityProvider(String alias, String displayName, String providerId, String loginUrl, String guiOrder) {
            this.alias = alias;
            this.displayName = displayName;
            this.providerId = providerId;
            this.loginUrl = loginUrl;
            this.guiOrder = guiOrder;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

