/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.LoginStatusIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.endpoints.UserInfoEndpoint;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CacheControlUtil;

public class OIDCLoginProtocolService {
    private RealmModel realm;
    private TokenManager tokenManager;
    private EventBuilder event;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private HttpHeaders headers;
    @Context
    private HttpRequest request;

    public OIDCLoginProtocolService(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.tokenManager = new TokenManager();
        this.event = event;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/openid-connect");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "auth");
    }

    public static UriBuilder tokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "token");
    }

    public static UriBuilder certsUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "certs");
    }

    public static UriBuilder userInfoUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "issueUserInfo");
    }

    public static UriBuilder tokenIntrospectionUrl(UriBuilder baseUriBuilder) {
        return OIDCLoginProtocolService.tokenUrl(baseUriBuilder).path(TokenEndpoint.class, "introspect");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "logout");
    }

    @Path(value="auth")
    public Object auth() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="registrations")
    public Object registerPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.register();
    }

    @Path(value="forgot-credentials")
    public Object forgotCredentialsPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.forgotCredentials();
    }

    @Path(value="token")
    public Object token() {
        TokenEndpoint endpoint = new TokenEndpoint(this.tokenManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="login-status-iframe.html")
    public Object getLoginStatusIframe() {
        LoginStatusIframeEndpoint endpoint = new LoginStatusIframeEndpoint(this.realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @OPTIONS
    @Path(value="certs")
    @Produces(value={"application/json"})
    public Response getVersionPreflight() {
        return Cors.add(this.request, Response.ok()).allowedMethods("GET").preflight().auth().build();
    }

    @GET
    @Path(value="certs")
    @Produces(value={"application/json"})
    @NoCache
    public Response certs() {
        List publicKeys = this.session.keys().getKeys(this.realm, false);
        JWK[] keys = new JWK[publicKeys.size()];
        int i = 0;
        for (KeyMetadata k : publicKeys) {
            keys[i++] = JWKBuilder.create().kid(k.getKid()).rs256(k.getPublicKey());
        }
        JSONWebKeySet keySet = new JSONWebKeySet();
        keySet.setKeys(keys);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)keySet).cacheControl(CacheControlUtil.getDefaultCacheControl());
        return Cors.add(this.request, responseBuilder).allowedOrigins("*").auth().build();
    }

    @Path(value="userinfo")
    public Object issueUserInfo() {
        UserInfoEndpoint endpoint = new UserInfoEndpoint(this.tokenManager, this.realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="logout")
    public Object logout() {
        LogoutEndpoint endpoint = new LogoutEndpoint(this.tokenManager, this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        if (code != null) {
            return forms.setClientSessionCode(code).createCode();
        }
        return forms.setError(error, new Object[0]).createCode();
    }
}

