/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.net.URI;
import java.security.cert.Certificate;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.Config;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.services.resources.RealmsResource;

public class SamlIDPDescriptorClientInstallation
implements ClientInstallationProvider {
    public static String getIDPDescriptorForClient(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        SamlClient samlClient = new SamlClient(client);
        String idpEntityId = RealmsResource.realmBaseUrl(UriBuilder.fromUri((URI)serverBaseUri)).build(new Object[]{realm.getName()}).toString();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<EntityDescriptor entityID=\"").append(idpEntityId).append("\"\n                   xmlns=\"urn:oasis:names:tc:SAML:2.0:metadata\"\n                   xmlns:dsig=\"http://www.w3.org/2000/09/xmldsig#\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n   <IDPSSODescriptor WantAuthnRequestsSigned=\"").append(samlClient.requiresClientSignature()).append("\"\n      protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n");
        if (samlClient.forceNameIDFormat() && samlClient.getNameIDFormat() != null) {
            sb.append("   <NameIDFormat>").append(samlClient.getNameIDFormat()).append("</NameIDFormat>\n");
        } else {
            sb.append("   <NameIDFormat>urn:oasis:names:tc:SAML:2.0:nameid-format:persistent</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</NameIDFormat>\n");
        }
        String bindUrl = RealmsResource.protocolUrl(UriBuilder.fromUri((URI)serverBaseUri)).build(new Object[]{realm.getName(), "saml"}).toString();
        sb.append("\n      <SingleSignOnService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n         Location=\"").append(bindUrl).append("\" />\n");
        if (!samlClient.forcePostBinding()) {
            sb.append("      <SingleSignOnService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n         Location=\"").append(bindUrl).append("\" />\n");
        }
        sb.append("      <SingleLogoutService\n         Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n         Location=\"").append(bindUrl).append("\" />\n");
        if (!samlClient.forcePostBinding()) {
            sb.append("      <SingleLogoutService\n         Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n         Location=\"").append(bindUrl).append("\" />\n");
        }
        TreeSet keys = new TreeSet((o1, o2) -> o1.getStatus() == o2.getStatus() ? (int)(o2.getProviderPriority() - o1.getProviderPriority()) : (o1.getStatus() == KeyMetadata.Status.PASSIVE ? 1 : -1));
        keys.addAll(session.keys().getKeys(realm, false));
        for (KeyMetadata key : keys) {
            SamlIDPDescriptorClientInstallation.addKeyInfo(sb, key, KeyTypes.SIGNING.value());
        }
        sb.append("   </IDPSSODescriptor>\n</EntityDescriptor>\n");
        return sb.toString();
    }

    private static void addKeyInfo(StringBuilder target, KeyMetadata key, String purpose) {
        if (key == null) {
            return;
        }
        target.append(SPMetadataDescriptor.xmlKeyInfo((String)"      ", (String)key.getKid(), (String)PemUtils.encodeCertificate((Certificate)key.getCertificate()), (String)purpose, (boolean)false));
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        String descriptor = SamlIDPDescriptorClientInstallation.getIDPDescriptorForClient(session, realm, client, serverBaseUri);
        return Response.ok((Object)descriptor, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "SAML Metadata IDPSSODescriptor";
    }

    public String getHelpText() {
        return "SAML Metadata IDSSODescriptor tailored for the client.  This is special because not every client may require things like digital signatures";
    }

    public String getFilename() {
        return "client-tailored-saml-idp-metadata.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "saml-idp-descriptor";
    }
}

