/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public abstract class AbstractRsaKeyProvider
implements KeyProvider {
    private final KeyStatus status;
    private final ComponentModel model;
    private final KeyWrapper key;
    private final String algorithm;

    public AbstractRsaKeyProvider(RealmModel realm, ComponentModel model) {
        this.model = model;
        this.status = KeyStatus.from((boolean)model.get("active", true), (boolean)model.get("enabled", true));
        String defaultAlgorithmKey = KeyUse.ENC.name().equals(model.get("keyUse")) ? "RSA-OAEP" : "RS256";
        this.algorithm = model.get("algorithm", defaultAlgorithmKey);
        if (model.hasNote(KeyWrapper.class.getName())) {
            this.key = (KeyWrapper)model.getNote(KeyWrapper.class.getName());
        } else {
            this.key = this.loadKey(realm, model);
            model.setNote(KeyWrapper.class.getName(), (Object)this.key);
        }
    }

    protected abstract KeyWrapper loadKey(RealmModel var1, ComponentModel var2);

    public Stream<KeyWrapper> getKeysStream() {
        return Stream.of(this.key);
    }

    protected KeyWrapper createKeyWrapper(KeyPair keyPair, X509Certificate certificate, KeyUse keyUse) {
        return this.createKeyWrapper(keyPair, certificate, Collections.emptyList(), keyUse);
    }

    protected KeyWrapper createKeyWrapper(KeyPair keyPair, X509Certificate certificate, List<X509Certificate> certificateChain, KeyUse keyUse) {
        KeyWrapper key = new KeyWrapper();
        key.setProviderId(this.model.getId());
        key.setProviderPriority(this.model.get("priority", 0L));
        key.setKid(KeyUtils.createKeyId((Key)keyPair.getPublic()));
        key.setUse(keyUse == null ? KeyUse.SIG : keyUse);
        key.setType("RSA");
        key.setAlgorithm(this.algorithm);
        key.setStatus(this.status);
        key.setPrivateKey((Key)keyPair.getPrivate());
        key.setPublicKey((Key)keyPair.getPublic());
        key.setCertificate(certificate);
        if (!certificateChain.isEmpty()) {
            if (certificate != null && !certificate.equals(certificateChain.get(0))) {
                certificateChain.add(0, certificate);
            }
            key.setCertificateChain(certificateChain);
        }
        return key;
    }
}

