/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.google.common.collect.Streams;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public class IdentityProviderResource {
    protected static final Logger logger = Logger.getLogger(IdentityProviderResource.class);
    private final AdminPermissionEvaluator auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private final IdentityProviderModel identityProviderModel;
    private final AdminEventBuilder adminEvent;

    public IdentityProviderResource(AdminPermissionEvaluator auth, RealmModel realm, KeycloakSession session, IdentityProviderModel identityProviderModel, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.identityProviderModel = identityProviderModel;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.IDENTITY_PROVIDER);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public IdentityProviderRepresentation getIdentityProvider() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)this.identityProviderModel);
        return StripSecretsUtils.strip((IdentityProviderRepresentation)rep);
    }

    @DELETE
    @NoCache
    public Response delete() {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        String alias = this.identityProviderModel.getAlias();
        this.session.users().preRemove(this.realm, this.identityProviderModel);
        this.realm.removeIdentityProviderByAlias(alias);
        this.realm.getIdentityProviderMappersByAliasStream(alias).collect(Collectors.toList()).forEach(arg_0 -> ((RealmModel)this.realm).removeIdentityProviderMapper(arg_0));
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    public Response update(IdentityProviderRepresentation providerRep) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        try {
            this.updateIdpFromRep(providerRep, this.realm, this.session);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(providerRep).success();
            return Response.noContent().build();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Invalid request";
            }
            throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Identity Provider " + providerRep.getAlias() + " already exists");
        }
    }

    private void updateIdpFromRep(IdentityProviderRepresentation providerRep, RealmModel realm, KeycloakSession session) {
        IdentityProviderModel updated;
        String internalId = providerRep.getInternalId();
        String newProviderId = providerRep.getAlias();
        String oldProviderId = IdentityProviderResource.getProviderIdByInternalId(realm, internalId);
        if (oldProviderId == null) {
            IdentityProviderResource.lookUpProviderIdByAlias(realm, providerRep);
        }
        if ((updated = RepresentationToModel.toModel((RealmModel)realm, (IdentityProviderRepresentation)providerRep, (KeycloakSession)session)).getConfig() != null && "**********".equals(updated.getConfig().get("clientSecret"))) {
            updated.getConfig().put("clientSecret", this.identityProviderModel.getConfig() != null ? (String)this.identityProviderModel.getConfig().get("clientSecret") : null);
        }
        realm.updateIdentityProvider(updated);
        if (oldProviderId != null && !oldProviderId.equals(newProviderId)) {
            logger.debug((Object)("Changing providerId in all clients and linked users. oldProviderId=" + oldProviderId + ", newProviderId=" + newProviderId));
            IdentityProviderResource.updateUsersAfterProviderAliasChange(session.users().searchForUserStream(realm, Collections.singletonMap("keycloak.session.realm.users.query.include_service_account", Boolean.FALSE.toString())), oldProviderId, newProviderId, realm, session);
        }
    }

    private static String getProviderIdByInternalId(RealmModel realm, String providerInternalId) {
        return realm.getIdentityProvidersStream().filter(p -> Objects.equals(p.getInternalId(), providerInternalId)).map(IdentityProviderModel::getAlias).findFirst().orElse(null);
    }

    private static void lookUpProviderIdByAlias(RealmModel realm, IdentityProviderRepresentation providerRep) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProvidersStream().filter(p -> Objects.equals(p.getAlias(), providerRep.getAlias())).findFirst().orElseThrow(NotFoundException::new);
        providerRep.setInternalId(identityProviderModel.getInternalId());
    }

    private static void updateUsersAfterProviderAliasChange(Stream<UserModel> users, String oldProviderId, String newProviderId, RealmModel realm, KeycloakSession session) {
        users.forEach(user -> {
            FederatedIdentityModel federatedIdentity = session.users().getFederatedIdentity(realm, user, oldProviderId);
            if (federatedIdentity != null) {
                session.users().removeFederatedIdentity(realm, user, oldProviderId);
                FederatedIdentityModel newFederatedIdentity = new FederatedIdentityModel(newProviderId, federatedIdentity.getUserId(), federatedIdentity.getUserName(), federatedIdentity.getToken());
                session.users().addFederatedIdentity(realm, user, newFederatedIdentity);
            }
        });
    }

    private IdentityProviderFactory getIdentityProviderFactory() {
        return Streams.concat((Stream[])new Stream[]{this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class), this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class)}).filter(providerFactory -> Objects.equals(providerFactory.getId(), this.identityProviderModel.getProviderId())).map(IdentityProviderFactory.class::cast).findFirst().orElse(null);
    }

    @GET
    @Path(value="export")
    @NoCache
    public Response export(@QueryParam(value="format") String format) {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        try {
            IdentityProviderFactory factory = this.getIdentityProviderFactory();
            return factory.create(this.session, this.identityProviderModel).export((UriInfo)this.session.getContext().getUri(), this.realm, format);
        }
        catch (Exception e) {
            throw ErrorResponse.error("Could not export public broker configuration for identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="mapper-types")
    @NoCache
    public Map<String, IdentityProviderMapperTypeRepresentation> getMapperTypes() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        return sessionFactory.getProviderFactoriesStream(IdentityProviderMapper.class).map(IdentityProviderMapper.class::cast).map(mapper -> Arrays.stream(mapper.getCompatibleProviders()).filter(type -> Objects.equals("*", type) || Objects.equals(this.identityProviderModel.getProviderId(), type)).map(type -> {
            IdentityProviderMapperTypeRepresentation rep = new IdentityProviderMapperTypeRepresentation();
            rep.setId(mapper.getId());
            rep.setCategory(mapper.getDisplayCategory());
            rep.setName(mapper.getDisplayType());
            rep.setHelpText(mapper.getHelpText());
            rep.setProperties(mapper.getConfigProperties().stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList()));
            return rep;
        }).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(IdentityProviderMapperTypeRepresentation::getId, Function.identity()));
    }

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    @NoCache
    public Stream<IdentityProviderMapperRepresentation> getMappers() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        return this.realm.getIdentityProviderMappersByAliasStream(this.identityProviderModel.getAlias()).map(ModelToRepresentation::toRepresentation);
    }

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    public Response addMapper(IdentityProviderMapperRepresentation mapper) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)mapper);
        try {
            model = this.realm.addIdentityProviderMapper(model);
        }
        catch (Exception e) {
            throw ErrorResponse.error("Failed to add mapper '" + model.getName() + "' to identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(mapper).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @NoCache
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    public IdentityProviderMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((IdentityProviderMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, IdentityProviderMapperRepresentation rep) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)rep);
        this.realm.updateIdentityProviderMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="mappers/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.realm.removeIdentityProviderMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ManagementPermissionReference getManagementPermissions() {
        this.auth.realm().requireViewIdentityProviders();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.idps().isPermissionsEnabled(this.identityProviderModel)) {
            return new ManagementPermissionReference();
        }
        return IdentityProviderResource.toMgmtRef(this.identityProviderModel, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(IdentityProviderModel model, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.idps().resource(model).getId());
        ref.setScopePermissions(permissions.idps().getPermissions(model));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        this.auth.realm().requireManageIdentityProviders();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.idps().setPermissionsEnabled(this.identityProviderModel, ref.isEnabled());
        if (ref.isEnabled()) {
            return IdentityProviderResource.toMgmtRef(this.identityProviderModel, permissions);
        }
        return new ManagementPermissionReference();
    }
}

