/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.resetcred;

import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.resetcred.ResetCredentialsActionToken;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.events.EventType;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.LoginActionsServiceChecks;
import org.keycloak.sessions.CommonClientSessionModel;

public class ResetCredentialsActionTokenHandler
extends AbstractActionTokenHandler<ResetCredentialsActionToken> {
    public ResetCredentialsActionTokenHandler() {
        super("reset-credentials", ResetCredentialsActionToken.class, "resetCredentialNotAllowedMessage", EventType.RESET_PASSWORD, "not_allowed");
    }

    @Override
    public TokenVerifier.Predicate<? super ResetCredentialsActionToken>[] getVerifiers(ActionTokenContext<ResetCredentialsActionToken> tokenContext) {
        TokenVerifier.Predicate[] predicateArray = new TokenVerifier.Predicate[3];
        predicateArray[0] = TokenUtils.checkThat(() -> ((RealmModel)tokenContext.getRealm()).isResetPasswordAllowed(), "not_allowed", "resetCredentialNotAllowedMessage");
        predicateArray[1] = this.verifyEmail(tokenContext);
        predicateArray[2] = new LoginActionsServiceChecks.IsActionRequired(tokenContext, CommonClientSessionModel.Action.AUTHENTICATE);
        return TokenUtils.predicates(predicateArray);
    }

    @Override
    public Response handleToken(ResetCredentialsActionToken token, ActionTokenContext tokenContext) {
        ResetCredsAuthenticationProcessor authProcessor = new ResetCredsAuthenticationProcessor();
        return tokenContext.processFlow(false, "reset-credentials", tokenContext.getRealm().getResetCredentialsFlow(), null, authProcessor);
    }

    @Override
    public boolean canUseTokenRepeatedly(ResetCredentialsActionToken token, ActionTokenContext tokenContext) {
        return false;
    }

    public static class ResetCredsAuthenticationProcessor
    extends AuthenticationProcessor {
        @Override
        protected Response authenticationComplete() {
            boolean firstBrokerLoginInProgress;
            boolean bl = firstBrokerLoginInProgress = this.authenticationSession.getAuthNote("BROKERED_CONTEXT") != null;
            if (firstBrokerLoginInProgress) {
                UserModel linkingUser = AbstractIdpAuthenticator.getExistingUser(this.session, this.realm, this.authenticationSession);
                SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(this.authenticationSession, "BROKERED_CONTEXT");
                this.authenticationSession.setAuthNote("FIRST_BROKER_LOGIN_SUCCESS", serializedCtx.getIdentityProviderId());
                logger.debugf("Forget-password flow finished when authenticated user '%s' after first broker login with identity provider '%s'.", (Object)linkingUser.getUsername(), (Object)serializedCtx.getIdentityProviderId());
                return LoginActionsService.redirectToAfterBrokerLoginEndpoint(this.session, this.realm, this.uriInfo, this.authenticationSession, true);
            }
            return super.authenticationComplete();
        }
    }
}

