/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.io.IOException;
import java.net.URI;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.services.Urls;
import org.keycloak.theme.Theme;

public class UrlBean {
    private static final Logger logger = Logger.getLogger(UrlBean.class);
    private final URI actionuri;
    private URI baseURI;
    private Theme theme;
    private String realm;

    public UrlBean(RealmModel realm, Theme theme, URI baseURI, URI actionUri) {
        this.realm = realm != null ? realm.getName() : null;
        this.theme = theme;
        this.baseURI = baseURI;
        this.actionuri = actionUri;
    }

    public String getLoginAction() {
        if (this.actionuri != null) {
            return this.actionuri.toString();
        }
        throw new RuntimeException("action URI not set");
    }

    public String getLoginUrl() {
        return Urls.realmLoginPage(this.baseURI, this.realm).toString();
    }

    public String getLoginRestartFlowUrl() {
        return Urls.realmLoginRestartPage(this.baseURI, this.realm).toString();
    }

    public boolean hasAction() {
        return this.actionuri != null;
    }

    public String getRegistrationAction() {
        if (this.actionuri != null) {
            return this.actionuri.toString();
        }
        return Urls.realmRegisterAction(this.baseURI, this.realm).toString();
    }

    public String getRegistrationUrl() {
        return Urls.realmRegisterPage(this.baseURI, this.realm).toString();
    }

    public String getLoginUpdatePasswordUrl() {
        return Urls.loginActionUpdatePassword(this.baseURI, this.realm).toString();
    }

    public String getLoginUpdateTotpUrl() {
        return Urls.loginActionUpdateTotp(this.baseURI, this.realm).toString();
    }

    public String getLoginUpdateProfileUrl() {
        return Urls.loginActionUpdateProfile(this.baseURI, this.realm).toString();
    }

    public String getLoginResetCredentialsUrl() {
        return Urls.loginResetCredentials(this.baseURI, this.realm).toString();
    }

    public String getLoginUsernameReminderUrl() {
        return Urls.loginUsernameReminder(this.baseURI, this.realm).toString();
    }

    public String getFirstBrokerLoginUrl() {
        return Urls.firstBrokerLoginProcessor(this.baseURI, this.realm).toString();
    }

    public String getLogoutConfirmAction() {
        return Urls.logoutConfirm(this.baseURI, this.realm).toString();
    }

    public String getResourcesUrl() {
        return Urls.themeRoot(this.baseURI).toString() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }

    public String getOauthAction() {
        if (this.actionuri != null) {
            return this.actionuri.getPath();
        }
        return Urls.realmOauthAction(this.baseURI, this.realm).toString();
    }

    public String getOauth2DeviceVerificationAction() {
        if (this.actionuri != null) {
            return this.actionuri.getPath();
        }
        return DeviceGrantType.realmOAuth2DeviceVerificationAction(this.baseURI, this.realm).toString();
    }

    public String getResourcesPath() {
        URI uri = Urls.themeRoot(this.baseURI);
        return uri.getPath() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }

    public String getResourcesCommonPath() {
        URI uri = Urls.themeRoot(this.baseURI);
        String commonPath = "";
        try {
            commonPath = this.theme.getProperties().getProperty("import");
        }
        catch (IOException ex) {
            logger.warn((Object)"Failed to load properties", (Throwable)ex);
        }
        if (commonPath == null || commonPath.isEmpty()) {
            commonPath = "/common/keycloak";
        }
        return uri.getPath() + "/" + commonPath;
    }
}

