/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.ecp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.w3c.dom.Document;

public class SamlEcpProfileService
extends SamlService {
    private static final String NS_PREFIX_PROFILE_ECP = "ecp";
    private static final String NS_PREFIX_SAML_PROTOCOL = "samlp";
    private static final String NS_PREFIX_SAML_ASSERTION = "saml";

    public SamlEcpProfileService(KeycloakSession session, EventBuilder event, DestinationValidator destinationValidator) {
        super(session, event, destinationValidator);
    }

    public Response authenticate(InputStream inputStream) {
        return this.authenticate(Soap.extractSoapMessage(inputStream));
    }

    public Response authenticate(Document soapMessage) {
        try {
            return new SamlService.PostBindingProtocol(){

                @Override
                protected Response error(KeycloakSession session, AuthenticationSessionModel authenticationSession, Response.Status status, String message, Object ... parameters) {
                    return Soap.createFault().code("error").reason(message).build();
                }

                @Override
                protected String getBindingType(AuthnRequestType requestAbstractType) {
                    return "soap";
                }

                @Override
                protected String getBindingType() {
                    return "soap";
                }

                @Override
                protected boolean isDestinationRequired() {
                    return false;
                }

                @Override
                protected Response loginRequest(String relayState, AuthnRequestType requestAbstractType, ClientModel client) {
                    if (!new SamlClient(client).allowECPFlow()) {
                        logger.errorf("Client %s is not allowed to execute ECP flow", (Object)client.getClientId());
                        throw new RuntimeException("Client is not allowed to use ECP profile.");
                    }
                    requestAbstractType.setIsPassive(Boolean.valueOf(true));
                    requestAbstractType.setDestination(SamlEcpProfileService.this.session.getContext().getUri().getAbsolutePath());
                    return super.loginRequest(relayState, requestAbstractType, client);
                }
            }.execute(Soap.toSamlHttpPostMessage(soapMessage), null, null, null);
        }
        catch (Exception e) {
            String reason = "Some error occurred while processing the AuthnRequest.";
            String detail = e.getMessage();
            if (detail == null) {
                detail = reason;
            }
            return Soap.createFault().reason(reason).detail(detail).build();
        }
    }

    @Override
    protected Response newBrowserAuthentication(AuthenticationSessionModel authSession, boolean isPassive, boolean redirectToAuthentication, SamlProtocol samlProtocol) {
        authSession.setClientNote("USER_SESSION_PERSISTENT_STATE", UserSessionModel.SessionPersistenceState.TRANSIENT.toString());
        return super.newBrowserAuthentication(authSession, isPassive, redirectToAuthentication, this.createEcpSamlProtocol());
    }

    private SamlProtocol createEcpSamlProtocol() {
        return new SamlProtocol(){

            @Override
            protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
                Document document = bindingBuilder.postBinding(samlDocument).getDocument();
                try {
                    Soap.SoapMessageBuilder messageBuilder = Soap.createMessage().addNamespace(SamlEcpProfileService.NS_PREFIX_SAML_ASSERTION, JBossSAMLURIConstants.ASSERTION_NSURI.get()).addNamespace(SamlEcpProfileService.NS_PREFIX_SAML_PROTOCOL, JBossSAMLURIConstants.PROTOCOL_NSURI.get()).addNamespace(SamlEcpProfileService.NS_PREFIX_PROFILE_ECP, JBossSAMLURIConstants.ECP_PROFILE.get());
                    this.createEcpResponseHeader(redirectUri, messageBuilder);
                    this.createRequestAuthenticatedHeader(clientSession, messageBuilder);
                    messageBuilder.addToBody(document);
                    return messageBuilder.build();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while creating SAML response.", e);
                }
            }

            private void createRequestAuthenticatedHeader(AuthenticatedClientSessionModel clientSession, Soap.SoapMessageBuilder messageBuilder) {
                ClientModel client = clientSession.getClient();
                if ("true".equals(client.getAttribute("saml.client.signature"))) {
                    SOAPHeaderElement ecpRequestAuthenticated = messageBuilder.addHeader(JBossSAMLConstants.REQUEST_AUTHENTICATED.get(), SamlEcpProfileService.NS_PREFIX_PROFILE_ECP);
                    ecpRequestAuthenticated.setMustUnderstand(true);
                    ecpRequestAuthenticated.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                }
            }

            private void createEcpResponseHeader(String redirectUri, Soap.SoapMessageBuilder messageBuilder) throws SOAPException {
                SOAPHeaderElement ecpResponseHeader = messageBuilder.addHeader(JBossSAMLConstants.RESPONSE__ECP.get(), SamlEcpProfileService.NS_PREFIX_PROFILE_ECP);
                ecpResponseHeader.setMustUnderstand(true);
                ecpResponseHeader.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                ecpResponseHeader.addAttribute(messageBuilder.createName(JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_URL.get()), redirectUri);
            }

            @Override
            protected Response buildErrorResponse(boolean isPostBinding, String uri, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
                return Soap.createMessage().addToBody(document).build();
            }

            @Override
            protected Response buildLogoutResponse(UserSessionModel userSession, String logoutBindingUri, SAML2LogoutResponseBuilder builder, JaxrsSAML2BindingBuilder binding) throws ConfigurationException, ProcessingException, IOException {
                return Soap.createFault().reason("Logout not supported.").build();
            }
        }.setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri());
    }

    @Override
    protected AuthenticationFlowModel getAuthenticationFlow(AuthenticationSessionModel authSession) {
        return this.realm.getAuthenticationFlowsStream().filter(flow -> Objects.equals(flow.getAlias(), "saml ecp")).findFirst().orElseThrow(() -> new RuntimeException("Could not resolve authentication flow for SAML ECP Profile."));
    }
}

