/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.keycloak.common.Version;
import org.keycloak.encoding.ResourceEncodingHelper;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.CacheControlUtil;

@Path(value="/js")
public class JsResource {
    @Context
    private KeycloakSession session;

    @GET
    @Path(value="/keycloak.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakJs(@QueryParam(value="version") String version) {
        return this.getJs("keycloak.js", version);
    }

    @GET
    @Path(value="/{version}/keycloak.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakJsWithVersion(@PathParam(value="version") String version) {
        return this.getJs("keycloak.js", version);
    }

    @GET
    @Path(value="/keycloak.min.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakMinJs(@QueryParam(value="version") String version) {
        return this.getJs("keycloak.min.js", version);
    }

    @GET
    @Path(value="/{version}/keycloak.min.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakMinJsWithVersion(@PathParam(value="version") String version) {
        return this.getJs("keycloak.min.js", version);
    }

    @GET
    @Path(value="/keycloak-authz.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakAuthzJs(@QueryParam(value="version") String version) {
        return this.getJs("keycloak-authz.js", version);
    }

    @GET
    @Path(value="/{version}/keycloak-authz.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakAuthzJsWithVersion(@PathParam(value="version") String version) {
        return this.getJs("keycloak-authz.js", version);
    }

    @GET
    @Path(value="/keycloak-authz.min.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakAuthzMinJs(@QueryParam(value="version") String version) {
        return this.getJs("keycloak-authz.min.js", version);
    }

    @GET
    @Path(value="/{version}/keycloak-authz.min.js")
    @Produces(value={"text/javascript; charset=utf-8"})
    public Response getKeycloakAuthzMinJsWithVersion(@PathParam(value="version") String version) {
        return this.getJs("keycloak-authz.min.js", version);
    }

    private Response getJs(String name, String version) {
        CacheControl cacheControl;
        if (version != null) {
            if (!version.equals(Version.RESOURCES_VERSION)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            cacheControl = CacheControlUtil.getDefaultCacheControl();
        } else {
            cacheControl = CacheControlUtil.noCache();
        }
        String contentType = "text/javascript";
        Cors cors = Cors.add(this.session.getContext().getHttpRequest()).allowAllOrigins();
        ResourceEncodingProvider encodingProvider = ResourceEncodingHelper.getResourceEncodingProvider(this.session, contentType);
        InputStream inputStream = encodingProvider != null ? encodingProvider.getEncodedStream(() -> this.getClass().getClassLoader().getResourceAsStream(name), "js", name) : this.getClass().getClassLoader().getResourceAsStream(name);
        if (inputStream != null) {
            Response.ResponseBuilder rb = Response.ok((Object)inputStream).type(contentType).cacheControl(cacheControl);
            if (encodingProvider != null) {
                rb.encoding(encodingProvider.getEncoding());
            }
            return cors.builder(rb).build();
        }
        return cors.builder(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }
}

