/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class AccountConsole {
    private final Pattern bundleParamPattern = Pattern.compile("(\\{\\s*(\\d+)\\s*\\})");
    protected final KeycloakSession session;
    private final AppAuthManager authManager;
    private final RealmModel realm;
    private final ClientModel client;
    private final Theme theme;
    private Auth auth;

    public AccountConsole(KeycloakSession session, ClientModel client, Theme theme) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.client = client;
        this.theme = theme;
        this.authManager = new AppAuthManager();
    }

    public void init() {
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm);
        if (authResult != null) {
            this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), this.client, authResult.getSession(), true);
        }
    }

    @GET
    @NoCache
    public Response getMainPage() throws IOException, FreeMarkerException {
        KeycloakUriInfo uriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        URI accountBaseUrl = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(this.realm.getName()).path("account").path("/").build(new Object[]{this.realm});
        if (!this.session.getContext().getUri().getRequestUri().getPath().endsWith("/")) {
            UriBuilder redirectUri = this.session.getContext().getUri().getRequestUriBuilder().uri(accountBaseUrl);
            return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        URI adminBaseUri = this.session.getContext().getUri(UrlType.ADMIN).getBaseUri();
        URI authUrl = uriInfo.getBaseUri();
        map.put("authUrl", authUrl.getPath().endsWith("/") ? authUrl : authUrl + "/");
        map.put("baseUrl", accountBaseUrl);
        map.put("realm", this.realm);
        map.put("resourceUrl", Urls.themeRoot(authUrl).getPath() + "/" + "account" + "/" + this.theme.getName());
        map.put("resourceCommonUrl", Urls.themeRoot(adminBaseUri).getPath() + "/common/keycloak");
        map.put("resourceVersion", Version.RESOURCES_VERSION);
        String[] referrer = this.getReferrer();
        if (referrer != null) {
            map.put("referrer", referrer[0]);
            map.put("referrerName", referrer[1]);
            map.put("referrer_uri", referrer[2]);
        }
        UserModel user = null;
        if (this.auth != null) {
            user = this.auth.getUser();
        }
        Locale locale = this.session.getContext().resolveLocale(user);
        map.put("locale", locale.toLanguageTag());
        Properties messages = new Properties();
        messages.putAll((Map<?, ?>)this.theme.getMessages(locale));
        if (StringUtil.isNotBlank((String)this.realm.getDefaultLocale())) {
            messages.putAll((Map<?, ?>)this.realm.getRealmLocalizationTextsByLocale(this.realm.getDefaultLocale()));
        }
        messages.putAll((Map<?, ?>)this.realm.getRealmLocalizationTextsByLocale(locale.toLanguageTag()));
        map.put("msg", new MessageFormatterMethod(locale, messages));
        map.put("msgJSON", this.messagesToJsonString(messages));
        map.put("supportedLocales", this.supportedLocales(messages));
        map.put("properties", this.theme.getProperties());
        map.put("theme", file -> {
            try {
                InputStream resource = this.theme.getResourceAsStream(file);
                return new Scanner(resource, "UTF-8").useDelimiter("\\A").next();
            }
            catch (IOException e) {
                throw new RuntimeException("could not load file", e);
            }
        });
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        map.put("isEventsEnabled", eventStore != null && this.realm.isEventsEnabled());
        map.put("isAuthorizationEnabled", Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION));
        boolean isTotpConfigured = false;
        boolean deleteAccountAllowed = false;
        boolean isViewGroupsEnabled = false;
        if (user != null) {
            isTotpConfigured = user.credentialManager().isConfiguredFor(this.realm.getOTPPolicy().getType());
            RoleModel deleteAccountRole = this.realm.getClientByClientId("account").getRole("delete-account");
            deleteAccountAllowed = deleteAccountRole != null && user.hasRole(deleteAccountRole) && this.realm.getRequiredActionProviderByAlias("delete_account").isEnabled();
            RoleModel viewGrouRole = this.realm.getClientByClientId("account").getRole("view-groups");
            isViewGroupsEnabled = viewGrouRole != null && user.hasRole(viewGrouRole);
        }
        map.put("isTotpConfigured", isTotpConfigured);
        map.put("deleteAccountAllowed", deleteAccountAllowed);
        map.put("isViewGroupsEnabled", isViewGroupsEnabled);
        map.put("updateEmailFeatureEnabled", Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL));
        RequiredActionProviderModel updateEmailActionProvider = this.realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.UPDATE_EMAIL.name());
        map.put("updateEmailActionEnabled", updateEmailActionProvider != null && updateEmailActionProvider.isEnabled());
        FreeMarkerProvider freeMarkerUtil = (FreeMarkerProvider)this.session.getProvider(FreeMarkerProvider.class);
        String result = freeMarkerUtil.processTemplate(map, "index.ftl", this.theme);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).type("text/html; charset=utf-8").language(Locale.ENGLISH).entity((Object)result);
        return builder.build();
    }

    private Map<String, String> supportedLocales(Properties messages) {
        return this.realm.getSupportedLocalesStream().collect(Collectors.toMap(Function.identity(), l -> messages.getProperty("locale_" + l, (String)l)));
    }

    private String messagesToJsonString(Properties props) {
        if (props == null) {
            return "";
        }
        Properties newProps = new Properties();
        for (String prop : props.stringPropertyNames()) {
            newProps.put(prop, this.convertPropValue(props.getProperty(prop)));
        }
        try {
            return JsonSerialization.writeValueAsString((Object)newProps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertPropValue(String propertyValue) {
        propertyValue = propertyValue.replaceAll("'('?)", "$1");
        propertyValue = this.putJavaParamsInNgTranslateFormat(propertyValue);
        return propertyValue;
    }

    private String putJavaParamsInNgTranslateFormat(String propertyValue) {
        Matcher matcher = this.bundleParamPattern.matcher(propertyValue);
        while (matcher.find()) {
            propertyValue = propertyValue.replace(matcher.group(1), "{{param_" + matcher.group(2) + "}}");
        }
        return propertyValue;
    }

    @GET
    @Path(value="index.html")
    public Response getIndexHtmlRedirect() {
        return Response.status((int)302).location(this.session.getContext().getUri().getRequestUriBuilder().path("../").build(new Object[0])).build();
    }

    private String[] getReferrer() {
        String referrer = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        String referrerUri = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer_uri");
        ClientModel referrerClient = this.realm.getClientByClientId(referrer);
        if (referrerClient != null && (referrerUri = referrerUri != null ? RedirectUtils.verifyRedirectUri(this.session, referrerUri, referrerClient) : ResolveRelative.resolveRelativeUri(this.session, referrerClient.getRootUrl(), referrerClient.getBaseUrl())) != null) {
            String referrerName = referrerClient.getName();
            if (Validation.isBlank(referrerName)) {
                referrerName = referrer;
            }
            return new String[]{referrer, referrerName, referrerUri};
        }
        return null;
    }
}

