/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientScopeResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientScopesResource {
    protected static final Logger logger = Logger.getLogger(ClientScopesResource.class);
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;

    public ClientScopesResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_SCOPE);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<ClientScopeRepresentation> getClientScopes() {
        this.auth.clients().requireListClientScopes();
        return this.auth.clients().canViewClientScopes() ? this.realm.getClientScopesStream().map(ModelToRepresentation::toRepresentation) : Stream.empty();
    }

    @POST
    @Consumes(value={"application/json"})
    @NoCache
    public Response createClientScope(ClientScopeRepresentation rep) {
        this.auth.clients().requireManageClientScopes();
        ClientScopeResource.validateClientScopeName(rep.getName());
        ClientScopeResource.validateDynamicClientScope(rep);
        try {
            ClientScopeModel clientModel = RepresentationToModel.createClientScope((KeycloakSession)this.session, (RealmModel)this.realm, (ClientScopeRepresentation)rep);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), clientModel.getId()).representation(rep).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Client Scope " + rep.getName() + " already exists");
        }
    }

    @Path(value="{id}")
    @NoCache
    public ClientScopeResource getClientScope(@PathParam(value="id") String id) {
        this.auth.clients().requireListClientScopes();
        ClientScopeModel clientModel = this.realm.getClientScopeById(id);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client scope");
        }
        return new ClientScopeResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
    }
}

