/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.broker.IdpCreateUserIfUniqueAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.ExistingUserInfo;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public class IdpDetectExistingBrokerUserAuthenticator
extends IdpCreateUserIfUniqueAuthenticator {
    private static final Logger logger = Logger.getLogger(IdpDetectExistingBrokerUserAuthenticator.class);

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        RealmModel realm = context.getRealm();
        if (context.getAuthenticationSession().getAuthNote("EXISTING_USER_INFO") != null) {
            context.attempted();
            return;
        }
        String username = this.getUsername(context, serializedCtx, brokerContext);
        if (username == null) {
            ServicesLogger.LOGGER.resetFlow(realm.isRegistrationEmailAsUsername() ? "Email" : "Username");
            context.getAuthenticationSession().setAuthNote("ENFORCE_UPDATE_PROFILE", "true");
            context.resetFlow();
            return;
        }
        ExistingUserInfo duplication = this.checkExistingUser(context, username, serializedCtx, brokerContext);
        if (duplication == null) {
            logger.errorf("The user %s should be already registered in the realm to login %s", (Object)username, (Object)realm.getName());
            Response challengeResponse = context.form().setError("federatedIdentityUnavailableMessage", new Object[]{username, brokerContext.getIdpConfig().getAlias()}).createErrorPage(Response.Status.UNAUTHORIZED);
            context.challenge(challengeResponse);
            context.getEvent().detail("authenticator", "DetectExistingBrokerUser").removeDetail("auth_method").removeDetail("auth_type").error("user_not_found");
        } else {
            logger.debugf("Duplication detected. There is already existing user with %s '%s' .", (Object)duplication.getDuplicateAttributeName(), (Object)duplication.getDuplicateAttributeValue());
            context.getAuthenticationSession().setAuthNote("EXISTING_USER_INFO", duplication.serialize());
            context.success();
        }
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }
}

