/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.broker.oidc.mappers.AbstractClaimToGroupMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.utils.RegexUtils;

public class AdvancedClaimToGroupMapper
extends AbstractClaimToGroupMapper {
    public static final String CLAIM_PROPERTY_NAME = "claims";
    public static final String ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME = "are.claim.values.regex";
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-advanced-group-idp-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return true;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Group Importer";
    }

    public String getDisplayType() {
        return "Advanced Claim to Group";
    }

    public String getHelpText() {
        return "If all claims exists, assign the user to the specified group.";
    }

    @Override
    protected boolean applies(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Map claims = mapperModel.getConfigMap(CLAIM_PROPERTY_NAME);
        boolean areClaimValuesRegex = Boolean.parseBoolean((String)mapperModel.getConfig().get(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME));
        for (Map.Entry claim : claims.entrySet()) {
            Object value = AdvancedClaimToGroupMapper.getClaimValue(context, (String)claim.getKey());
            boolean claimValuesMismatch = !(!areClaimValuesRegex ? this.valueEquals((String)claim.getValue(), value) : RegexUtils.valueMatchesRegex((String)claim.getValue(), value));
            if (!claimValuesMismatch) continue;
            return false;
        }
        return true;
    }

    static {
        ProviderConfigProperty claimsProperty = new ProviderConfigProperty();
        claimsProperty.setName(CLAIM_PROPERTY_NAME);
        claimsProperty.setLabel("Claims");
        claimsProperty.setHelpText("Name and value of the claims to search for in token. You can reference nested claims using a '.', i.e. 'address.locality'. To use dot (.) literally, escape it with backslash (\\.)");
        claimsProperty.setType("Map");
        configProperties.add(claimsProperty);
        ProviderConfigProperty isClaimValueRegexProperty = new ProviderConfigProperty();
        isClaimValueRegexProperty.setName(ARE_CLAIM_VALUES_REGEX_PROPERTY_NAME);
        isClaimValueRegexProperty.setLabel("Regex Claim Values");
        isClaimValueRegexProperty.setHelpText("If enabled claim values are interpreted as regular expressions.");
        isClaimValueRegexProperty.setType("boolean");
        configProperties.add(isClaimValueRegexProperty);
        ProviderConfigProperty groupProperty = new ProviderConfigProperty();
        groupProperty.setName("group");
        groupProperty.setLabel("Group");
        groupProperty.setHelpText("Group to assign the user to if claim is present.");
        groupProperty.setType("Group");
        configProperties.add(groupProperty);
    }
}

