/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.partialimport.ErrorResponseException;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;

public class ClientRolesPartialImport {
    private final Map<String, Set<RoleRepresentation>> toOverwrite = new HashMap<String, Set<RoleRepresentation>>();
    private final Map<String, Set<RoleRepresentation>> toSkip = new HashMap<String, Set<RoleRepresentation>>();

    public Map<String, Set<RoleRepresentation>> getToOverwrite() {
        return this.toOverwrite;
    }

    public Map<String, Set<RoleRepresentation>> getToSkip() {
        return this.toSkip;
    }

    public Map<String, List<RoleRepresentation>> getRepList(PartialImportRepresentation partialImportRep) {
        if (partialImportRep.getRoles() == null) {
            return null;
        }
        return partialImportRep.getRoles().getClient();
    }

    public String getName(RoleRepresentation roleRep) {
        if (roleRep.getName() == null) {
            throw new IllegalStateException("Client role to import does not have a name");
        }
        return roleRep.getName();
    }

    public String getCombinedName(String clientId, RoleRepresentation roleRep) {
        return clientId + "-->" + this.getName(roleRep);
    }

    public boolean exists(RealmModel realm, KeycloakSession session, String clientId, RoleRepresentation roleRep) {
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            return false;
        }
        return client.getRolesStream().anyMatch(role -> Objects.equals(this.getName(roleRep), role.getName()));
    }

    private boolean clientExists(PartialImportRepresentation partialImportRep, RealmModel realm, String clientId) {
        if (realm.getClientByClientId(clientId) != null) {
            return true;
        }
        if (partialImportRep.getClients() == null) {
            return false;
        }
        for (ClientRepresentation client : partialImportRep.getClients()) {
            if (!clientId.equals(client.getClientId())) continue;
            return true;
        }
        return false;
    }

    public String existsMessage(String clientId, RoleRepresentation roleRep) {
        return "Client role '" + this.getName(roleRep) + "' for client '" + clientId + "' already exists.";
    }

    public ResourceType getResourceType() {
        return ResourceType.CLIENT_ROLE;
    }

    public void deleteRole(RealmModel realm, String clientId, RoleRepresentation roleRep) {
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            return;
        }
        RoleModel role = client.getRole(this.getName(roleRep));
        if (role == null) {
            return;
        }
        client.removeRole(role);
    }

    public void prepare(PartialImportRepresentation partialImportRep, RealmModel realm, KeycloakSession session) throws ErrorResponseException {
        Map<String, List<RoleRepresentation>> repList = this.getRepList(partialImportRep);
        if (repList == null || repList.isEmpty()) {
            return;
        }
        for (String clientId : repList.keySet()) {
            if (!this.clientExists(partialImportRep, realm, clientId)) {
                throw this.noClientFound(clientId);
            }
            this.toOverwrite.put(clientId, new HashSet());
            this.toSkip.put(clientId, new HashSet());
            block5: for (RoleRepresentation roleRep : repList.get(clientId)) {
                if (!this.exists(realm, session, clientId, roleRep)) continue;
                switch (partialImportRep.getPolicy()) {
                    case SKIP: {
                        this.toSkip.get(clientId).add(roleRep);
                        continue block5;
                    }
                    case OVERWRITE: {
                        this.toOverwrite.get(clientId).add(roleRep);
                        continue block5;
                    }
                }
                throw this.exists(this.existsMessage(clientId, roleRep));
            }
        }
    }

    protected ErrorResponseException exists(String message) {
        throw ErrorResponse.exists(message);
    }

    protected ErrorResponseException noClientFound(String clientId) {
        String message = "Can not import client roles for nonexistent client named " + clientId;
        throw ErrorResponse.error(message, Response.Status.PRECONDITION_FAILED);
    }

    public PartialImportResult overwritten(String clientId, String modelId, RoleRepresentation roleRep) {
        return PartialImportResult.overwritten((ResourceType)this.getResourceType(), (String)this.getCombinedName(clientId, roleRep), (String)modelId, (Object)roleRep);
    }

    public PartialImportResult skipped(String clientId, String modelId, RoleRepresentation roleRep) {
        return PartialImportResult.skipped((ResourceType)this.getResourceType(), (String)this.getCombinedName(clientId, roleRep), (String)modelId, (Object)roleRep);
    }

    public PartialImportResult added(String clientId, String modelId, RoleRepresentation roleRep) {
        return PartialImportResult.added((ResourceType)this.getResourceType(), (String)this.getCombinedName(clientId, roleRep), (String)modelId, (Object)roleRep);
    }

    public String getModelId(RealmModel realm, String clientId) {
        return realm.getClientByClientId(clientId).getId();
    }
}

