/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.Validators;

public class ImmutableAttributeValidator
implements SimpleValidator {
    public static final String ID = "up-immutable-attribute";
    private static final String DEFAULT_ERROR_MESSAGE = "error-user-attribute-read-only";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values;
        UserProfileAttributeValidationContext ac = (UserProfileAttributeValidationContext)context;
        AttributeContext attributeContext = ac.getAttributeContext();
        UserModel user = attributeContext.getUser();
        if (user == null) {
            return context;
        }
        List currentValue = user.getAttributeStream(inputHint).collect(Collectors.toList());
        if (!CollectionUtil.collectionEquals(currentValue, (Collection)(values = (List)input)) && this.isReadOnly(attributeContext)) {
            if (currentValue.isEmpty() && !Validators.notBlankValidator().validate((Object)values).isValid()) {
                return context;
            }
            context.addError(new ValidationError(ID, inputHint, DEFAULT_ERROR_MESSAGE));
        }
        return context;
    }

    private boolean isReadOnly(AttributeContext attributeContext) {
        return attributeContext.getMetadata().isReadOnly(attributeContext);
    }
}

