/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.UserSessionUtil;
import org.keycloak.util.JsonSerialization;

public class AccessTokenIntrospectionProvider
implements TokenIntrospectionProvider {
    private final KeycloakSession session;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private static final Logger logger = Logger.getLogger(AccessTokenIntrospectionProvider.class);

    public AccessTokenIntrospectionProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
    }

    public Response introspect(String token) {
        try {
            ObjectNode tokenMetadata;
            AccessToken accessToken = this.verifyAccessToken(token);
            accessToken = this.transformAccessToken(accessToken);
            if (accessToken != null) {
                String actor;
                UserSessionModel userSession;
                String sessionState;
                tokenMetadata = JsonSerialization.createObjectNode((Object)accessToken);
                tokenMetadata.put("client_id", accessToken.getIssuedFor());
                String scope = accessToken.getScope();
                if (scope != null && scope.trim().isEmpty()) {
                    tokenMetadata.remove("scope");
                }
                if (!tokenMetadata.has("username")) {
                    if (accessToken.getPreferredUsername() != null) {
                        tokenMetadata.put("username", accessToken.getPreferredUsername());
                    } else {
                        UserModel userModel = this.session.users().getUserById(this.realm, accessToken.getSubject());
                        if (userModel != null) {
                            tokenMetadata.put("username", userModel.getUsername());
                        }
                    }
                }
                if ((sessionState = accessToken.getSessionState()) != null && (userSession = this.session.sessions().getUserSession(this.realm, sessionState)) != null && (actor = userSession.getNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString())) != null) {
                    tokenMetadata.putObject("act").put("sub", actor);
                }
                tokenMetadata.put("token_type", accessToken.getType());
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", accessToken != null);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    private AccessToken transformAccessToken(AccessToken token) {
        UserSessionModel userSession;
        if (token == null) {
            return null;
        }
        ClientModel client = this.realm.getClientByClientId(token.getIssuedFor());
        EventBuilder event = new EventBuilder(this.realm, this.session, this.session.getContext().getConnection()).event(EventType.INTROSPECT_TOKEN).detail("auth_method", "validate_access_token");
        try {
            userSession = UserSessionUtil.findValidSession(this.session, this.realm, token, event, client);
        }
        catch (Exception e) {
            logger.debugf("Can not get user session: %s", (Object)e.getMessage());
            return token;
        }
        if (userSession.getUser() == null) {
            logger.debugf("User not found", new Object[0]);
            return token;
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession, this.session);
        AccessToken smallToken = this.getAccessTokenFromStoredData(token, userSession);
        return this.tokenManager.transformIntrospectionAccessToken(this.session, smallToken, userSession, clientSessionCtx);
    }

    private AccessToken getAccessTokenFromStoredData(AccessToken token, UserSessionModel userSession) {
        AccessToken newToken = new AccessToken();
        newToken.id(token.getId());
        newToken.type(token.getType());
        newToken.subject(token.getSubject() != null ? token.getSubject() : userSession.getUser().getId());
        newToken.iat(token.getIat());
        newToken.exp(token.getExp());
        newToken.issuedFor(token.getIssuedFor());
        newToken.issuer(token.getIssuer());
        newToken.setNonce(token.getNonce());
        newToken.setScope(token.getScope());
        newToken.setAuth_time(token.getAuth_time());
        newToken.setSessionState(token.getSessionState());
        newToken.audience(token.getAudience());
        newToken.setConfirmation(token.getConfirmation());
        return newToken;
    }

    protected AccessToken verifyAccessToken(String token) {
        AccessToken accessToken;
        try {
            TokenVerifier verifier = TokenVerifier.create((String)token, AccessToken.class).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            accessToken = (AccessToken)verifier.verify().getToken();
        }
        catch (VerificationException e) {
            logger.debugf("JWT check failed: %s", (Object)e.getMessage());
            return null;
        }
        RealmModel realm = this.session.getContext().getRealm();
        return this.tokenManager.checkTokenValidForIntrospection(this.session, realm, accessToken, false) ? accessToken : null;
    }

    public void close() {
    }
}

