/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class PersonNameProhibitedCharactersValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final String ID = "person-name-prohibited-characters";
    public static final PersonNameProhibitedCharactersValidator INSTANCE = new PersonNameProhibitedCharactersValidator();
    protected static final Pattern PATTERN = Pattern.compile("^[^<>&\"\\v$%!#?\u00a7;*~/\\\\|^=\\[\\]{}()\\p{Cntrl}]+$");
    public static final String MESSAGE_NO_MATCH = "error-person-name-invalid-character";
    public static final String CFG_ERROR_MESSAGE = "error-message";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return ID;
    }

    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (!PATTERN.matcher(value).matches()) {
            context.addError(new ValidationError(ID, inputHint, config.getStringOrDefault(CFG_ERROR_MESSAGE, MESSAGE_NO_MATCH)));
        }
    }

    public String getHelpText() {
        return "Basic person name (First, Middle, Last name) validator disallowing bunch of characters we really do not expect in names.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(CFG_ERROR_MESSAGE);
        property.setLabel("Error message key");
        property.setHelpText("Key of the error message in i18n bundle. Dafault message key is error-person-name-invalid-character");
        property.setType("String");
        configProperties.add(property);
    }
}

