/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.config;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.util.JsonSerialization;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.Validators;

public class UPConfigUtils {
    private static final String SYSTEM_DEFAULT_CONFIG_RESOURCE = "keycloak-default-user-profile.json";
    public static final String ROLE_USER = "user";
    public static final String ROLE_ADMIN = "admin";
    private static final Set<String> PSEUDOROLES = new HashSet<String>();

    public static UPConfig readConfig(InputStream is) throws IOException {
        return (UPConfig)JsonSerialization.readValue((InputStream)is, UPConfig.class);
    }

    public static UPConfig parseConfig(String rawConfig) throws IOException {
        return UPConfigUtils.readConfig(new ByteArrayInputStream(rawConfig.getBytes("UTF-8")));
    }

    public static List<String> validate(KeycloakSession session, UPConfig config) {
        List<String> errors = UPConfigUtils.validateAttributes(session, config);
        errors.addAll(UPConfigUtils.validateAttributeGroups(config));
        return errors;
    }

    private static List<String> validateAttributeGroups(UPConfig config) {
        long groupsWithoutName = config.getGroups().stream().filter(g -> g.getName() == null).collect(Collectors.counting());
        if (groupsWithoutName > 0L) {
            String errorMessage = "Name is mandatory for groups, found " + groupsWithoutName + " group(s) without name.";
            return Collections.singletonList(errorMessage);
        }
        return Collections.emptyList();
    }

    private static List<String> validateAttributes(KeycloakSession session, UPConfig config) {
        ArrayList<String> errors = new ArrayList<String>();
        Set groups = config.getGroups().stream().map(g -> g.getName()).collect(Collectors.toSet());
        if (config.getAttributes() != null) {
            HashSet attNamesCache = new HashSet();
            config.getAttributes().forEach(attribute -> UPConfigUtils.validateAttribute(session, attribute, groups, errors, attNamesCache));
            errors.addAll(UPConfigUtils.validateRootAttributes(config));
        } else {
            errors.add("UserProfile configuration without 'attributes' section is not allowed");
        }
        return errors;
    }

    private static List<String> validateRootAttributes(UPConfig config) {
        List attributes = config.getAttributes();
        if (attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        List attributeNames = attributes.stream().map(UPAttribute::getName).collect(Collectors.toList());
        for (String name : Arrays.asList("username", "email")) {
            if (attributeNames.contains(name)) continue;
            errors.add("The attribute '" + name + "' can not be removed");
        }
        return errors;
    }

    private static void validateAttribute(KeycloakSession session, UPAttribute attributeConfig, Set<String> groups, List<String> errors, Set<String> attNamesCache) {
        String attributeName = attributeConfig.getName();
        if (ObjectUtil.isBlank((CharSequence)attributeName)) {
            errors.add("Attribute configuration without 'name' is not allowed");
        } else if (attNamesCache.contains(attributeName)) {
            errors.add("Attribute configuration already exists with 'name':'" + attributeName + "'");
        } else {
            attNamesCache.add(attributeName);
            if (!UPConfigUtils.isValidAttributeName(attributeName)) {
                errors.add("Invalid attribute name (only letters, numbers and '.' '_' '-' special characters allowed): " + attributeName + "'");
            }
        }
        if (attributeConfig.getValidations() != null) {
            attributeConfig.getValidations().forEach((validator, validatorConfig) -> UPConfigUtils.validateValidationConfig(session, validator, validatorConfig, attributeName, errors));
        }
        if (attributeConfig.getPermissions() != null) {
            if (attributeConfig.getPermissions().getView() != null) {
                UPConfigUtils.validateRoles(attributeConfig.getPermissions().getView(), "permissions.view", errors, attributeName);
            }
            if (attributeConfig.getPermissions().getEdit() != null) {
                UPConfigUtils.validateRoles(attributeConfig.getPermissions().getEdit(), "permissions.edit", errors, attributeName);
            }
        }
        if (attributeConfig.getRequired() != null) {
            UPConfigUtils.validateRoles(attributeConfig.getRequired().getRoles(), "required.roles", errors, attributeName);
            UPConfigUtils.validateScopes(attributeConfig.getRequired().getScopes(), "required.scopes", attributeName, errors, session);
        }
        if (attributeConfig.getSelector() != null) {
            UPConfigUtils.validateScopes(attributeConfig.getSelector().getScopes(), "selector.scopes", attributeName, errors, session);
        }
        if (attributeConfig.getGroup() != null && !groups.contains(attributeConfig.getGroup())) {
            errors.add("Attribute '" + attributeName + "' references unknown group '" + attributeConfig.getGroup() + "'");
        }
        if (attributeConfig.getAnnotations() != null) {
            UPConfigUtils.validateAnnotations(attributeConfig.getAnnotations(), errors, attributeName);
        }
    }

    private static void validateAnnotations(Map<String, Object> annotations, List<String> errors, String attributeName) {
        if (annotations.containsKey("inputOptions") && !(annotations.get("inputOptions") instanceof List)) {
            errors.add("Annotation 'inputOptions' configured for attribute '" + attributeName + "' must be an array of values!'");
        }
        if (annotations.containsKey("inputOptionLabels") && !(annotations.get("inputOptionLabels") instanceof Map)) {
            errors.add("Annotation 'inputOptionLabels' configured for attribute '" + attributeName + "' must be an object!'");
        }
    }

    private static void validateScopes(Set<String> scopes, String propertyName, String attributeName, List<String> errors, KeycloakSession session) {
        if (scopes == null) {
            return;
        }
        for (String scope : scopes) {
            RealmModel realm = session.getContext().getRealm();
            Stream realmScopes = realm.getClientScopesStream();
            if (realmScopes.anyMatch(cs -> cs.getName().equals(scope))) continue;
            errors.add("'" + propertyName + "' configuration for attribute '" + attributeName + "' contains unsupported scope '" + scope + "'");
        }
    }

    public static boolean isValidAttributeName(String attributeName) {
        return Pattern.matches("[a-zA-Z0-9\\._\\-]+", attributeName);
    }

    private static void validateRoles(Set<String> roles, String fieldName, List<String> errors, String attributeName) {
        if (roles != null) {
            for (String role : roles) {
                if (PSEUDOROLES.contains(role)) continue;
                errors.add("'" + fieldName + "' configuration for attribute '" + attributeName + "' contains unsupported role '" + role + "'");
            }
        }
    }

    private static void validateValidationConfig(KeycloakSession session, String validator, Map<String, Object> validatorConfig, String attributeName, List<String> errors) {
        if (ObjectUtil.isBlank((CharSequence)validator)) {
            errors.add("Validation without validator id is defined for attribute '" + attributeName + "'");
        } else if (session != null) {
            if (Validators.validator((KeycloakSession)session, (String)validator) == null) {
                errors.add("Validator '" + validator + "' defined for attribute '" + attributeName + "' doesn't exist");
            } else {
                ValidationResult result = Validators.validateConfig((KeycloakSession)session, (String)validator, (ValidatorConfig)ValidatorConfig.configFromMap(validatorConfig));
                if (!result.isValid()) {
                    StringBuilder sb = new StringBuilder();
                    result.forEachError(err -> sb.append(err.toString() + ", "));
                    errors.add("Validator '" + validator + "' defined for attribute '" + attributeName + "' has incorrect configuration: " + sb.toString());
                }
            }
        }
    }

    public static String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String readSystemDefaultConfig() {
        String string;
        block8: {
            InputStream is = UPConfigUtils.getSystemDefaultConfig();
            try {
                string = StreamUtil.readString((InputStream)is, (Charset)Charset.defaultCharset());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to load default user profile config file", cause);
                }
            }
            is.close();
        }
        return string;
    }

    public static UPConfig parseSystemDefaultConfig() {
        return UPConfigUtils.parseConfig(UPConfigUtils.getSystemDefaultConfig());
    }

    public static UPConfig parseConfig(Path configPath) {
        UPConfig uPConfig;
        if (configPath == null) {
            throw new IllegalArgumentException("Null configPath");
        }
        FileInputStream is = new FileInputStream(configPath.toFile());
        try {
            uPConfig = UPConfigUtils.parseConfig(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to reaad default user profile configuration: " + configPath, ioe);
            }
        }
        ((InputStream)is).close();
        return uPConfig;
    }

    private static UPConfig parseConfig(InputStream is) {
        try {
            return (UPConfig)JsonSerialization.readValue((InputStream)is, UPConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse default user profile configuration stream", e);
        }
    }

    private static InputStream getSystemDefaultConfig() {
        return UPConfigUtils.class.getResourceAsStream(SYSTEM_DEFAULT_CONFIG_RESOURCE);
    }

    static {
        PSEUDOROLES.add(ROLE_ADMIN);
        PSEUDOROLES.add(ROLE_USER);
    }
}

